/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class SourceFileManager
implements JavaFileManager {
    final ClassPath sourceRoots;
    private final boolean ignoreExcludes;
    private static Logger log = Logger.getLogger(SourceFileManager.class.getName());

    public SourceFileManager(ClassPath sourceRoots, boolean ignoreExcludes) {
        this.sourceRoots = sourceRoots;
        this.ignoreExcludes = ignoreExcludes;
    }

    public List<JavaFileObject> list(JavaFileManager.Location l, String packageName, Set<JavaFileObject.Kind> kinds, boolean recursive) {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        String _name = packageName.replace('.', '/');
        if (_name.length() != 0) {
            _name = _name + '/';
        }
        for (ClassPath.Entry entry : this.sourceRoots.entries()) {
            FileObject tmpFile;
            FileObject root;
            if (!this.ignoreExcludes && !entry.includes(_name) || (root = entry.getRoot()) == null || (tmpFile = root.getFileObject(_name)) == null || !tmpFile.isFolder()) continue;
            Enumeration files = tmpFile.getChildren(recursive);
            while (files.hasMoreElements()) {
                String ext;
                JavaFileObject.Kind kind;
                FileObject file = (FileObject)files.nextElement();
                if (!this.ignoreExcludes && !entry.includes(file) || !kinds.contains((Object)(kind = "java".equalsIgnoreCase(ext = file.getExt()) ? JavaFileObject.Kind.SOURCE : ("class".equalsIgnoreCase(ext) || "sig".equalsIgnoreCase(ext) ? JavaFileObject.Kind.CLASS : ("html".equalsIgnoreCase(ext) ? JavaFileObject.Kind.HTML : JavaFileObject.Kind.OTHER))))) continue;
                result.add(SourceFileObject.create(file, root));
            }
        }
        return result;
    }

    @Override
    public javax.tools.FileObject getFileForInput(JavaFileManager.Location l, String pkgName, String relativeName) {
        String rp = FileObjects.getRelativePath(pkgName, relativeName);
        FileObject[] fileRootPair = this.findFile(rp);
        return fileRootPair == null ? null : SourceFileObject.create(fileRootPair[0], fileRootPair[1]);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind) {
        String[] namePair = FileObjects.getParentRelativePathAndName(className);
        if (namePair == null) {
            return null;
        }
        String ext = kind == JavaFileObject.Kind.CLASS ? "sig" : kind.extension.substring(1);
        for (ClassPath.Entry entry : this.sourceRoots.entries()) {
            FileObject[] children;
            FileObject parent;
            FileObject root = entry.getRoot();
            if (root == null || (parent = root.getFileObject(namePair[0])) == null) continue;
            for (FileObject child : children = parent.getChildren()) {
                if (!namePair[1].equals(child.getName()) || !ext.equalsIgnoreCase(child.getExt()) || !this.ignoreExcludes && !entry.includes(child)) continue;
                return SourceFileObject.create(child, root);
            }
        }
        return null;
    }

    @Override
    public javax.tools.FileObject getFileForOutput(JavaFileManager.Location l, String pkgName, String relativeName, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        if (StandardLocation.SOURCE_PATH != l) {
            throw new UnsupportedOperationException("Only StandardLocation.SOURCE_PATH is supported.");
        }
        String rp = FileObjects.getRelativePath(pkgName, relativeName);
        FileObject[] fileRootPair = this.findFile(rp);
        if (fileRootPair == null) {
            FileObject[] roots = this.sourceRoots.getRoots();
            if (roots.length == 0) {
                return null;
            }
            File rootFile = FileUtil.toFile((FileObject)roots[0]);
            if (rootFile == null) {
                return null;
            }
            return FileObjects.nbFileObject(new File(rootFile, FileObjects.convertFolder2Package(rp, File.separatorChar)).toURI().toURL(), roots[0]);
        }
        return SourceFileObject.create(fileRootPair[0], fileRootPair[1]);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        throw new UnsupportedOperationException("The SourceFileManager does not support write operations.");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public boolean handleOption(String head, Iterator<String> tail) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return true;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location l) {
        return null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location l, JavaFileObject jfo) {
        block7: {
            try {
                String result;
                if (jfo instanceof InferableJavaFileObject && (result = ((InferableJavaFileObject)jfo).inferBinaryName()) != null) {
                    return result;
                }
                FileObject fo = URLMapper.findFileObject((URL)jfo.toUri().toURL());
                FileObject root = null;
                if (root == null) {
                    for (FileObject rc : this.sourceRoots.getRoots()) {
                        if (!FileUtil.isParentOf((FileObject)rc, (FileObject)fo)) continue;
                        root = rc;
                    }
                }
                if (root != null) {
                    String relativePath = FileUtil.getRelativePath(root, (FileObject)fo);
                    int index = relativePath.lastIndexOf(46);
                    assert (index > 0);
                    String result2 = relativePath.substring(0, index).replace('/', '.');
                    return result2;
                }
            }
            catch (MalformedURLException e) {
                if (!log.isLoggable(Level.SEVERE)) break block7;
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public boolean isSameFile(javax.tools.FileObject fileObject, javax.tools.FileObject fileObject0) {
        return fileObject instanceof SourceFileObject && fileObject0 instanceof SourceFileObject && ((SourceFileObject)fileObject).handle.file != null && ((SourceFileObject)fileObject).handle.file == ((SourceFileObject)fileObject0).handle.file;
    }

    private FileObject[] findFile(String relativePath) {
        for (ClassPath.Entry entry : this.sourceRoots.entries()) {
            FileObject file;
            FileObject root;
            if (!this.ignoreExcludes && !entry.includes(relativePath) || (root = entry.getRoot()) == null || (file = root.getFileObject(relativePath)) == null) continue;
            return new FileObject[]{file, root};
        }
        return null;
    }
}

