/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.util.Arrays;
import java.util.List;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.testrunner.RubyOutputLineHandler;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerInputProcessorFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerLineConvertor;

public final class TestRunnerUtilities {
    private static final String TEST_JAVAC_CLASSPATH = "test.javac.classpath";
    private static final String TEST_JVM_ARGS = "test.jvm.args";
    private static final List<String> NB_RUNNER_FILES = Arrays.asList("nb_test_mediator.rb", "nb_test_runner.rb", "nb_suite_runner.rb", "nb_rspec_mediator.rb", "nb_autotest_loader.rb");

    private TestRunnerUtilities() {
    }

    static boolean useTestRunner(Project project, String property, RakeTask task, DefaultTaskEvaluator taskEvaluator) {
        PropertyEvaluator evaluator = (PropertyEvaluator)project.getLookup().lookup(PropertyEvaluator.class);
        if (evaluator == null || evaluator.getProperty(property) == null) {
            return taskEvaluator.isDefault(task);
        }
        String definedTasks = evaluator.getProperty(property);
        if ("".equals(definedTasks.trim())) {
            return false;
        }
        for (String each : definedTasks.split(",")) {
            if (!task.getTask().equals(each.trim())) continue;
            return true;
        }
        return false;
    }

    static void addProperties(RubyExecutionDescriptor descriptor, Project project) {
        PropertyEvaluator evaluator = (PropertyEvaluator)project.getLookup().lookup(PropertyEvaluator.class);
        if (evaluator == null) {
            return;
        }
        descriptor.addInitialArgs(evaluator.getProperty("ruby.options"));
        descriptor.setEncoding(evaluator.getProperty("source.encoding"));
        String classPath = evaluator.getProperty(TEST_JAVAC_CLASSPATH);
        if (classPath == null) {
            classPath = evaluator.getProperty("javac.classpath");
        }
        descriptor.classPath(classPath);
        String jvmArgs = evaluator.getProperty(TEST_JVM_ARGS);
        if (jvmArgs == null) {
            jvmArgs = evaluator.getProperty("jvm.args");
        }
        descriptor.jvmArguments(jvmArgs);
    }

    public static boolean filterOutFromStacktrace(String line) {
        for (String runnerFile : NB_RUNNER_FILES) {
            if (!line.contains(runnerFile)) continue;
            return true;
        }
        return false;
    }

    static void setUpConvertors(TestSession session, RubyExecutionDescriptor taskDescriptor, Manager manager, final TestRunnerLineConvertor convertor) {
        session.setOutputLineHandler((OutputLineHandler)new RubyOutputLineHandler(session.getFileLocator()));
        taskDescriptor.addOutConvertor((LineConvertor)convertor);
        taskDescriptor.addErrConvertor((LineConvertor)convertor);
        taskDescriptor.lineBased(true);
        final TestRunnerInputProcessorFactory outFactory = new TestRunnerInputProcessorFactory(manager, session, true);
        final TestRunnerInputProcessorFactory errFactory = new TestRunnerInputProcessorFactory(manager, session, false);
        taskDescriptor.setOutProcessorFactory((ExecutionDescriptor.InputProcessorFactory)outFactory);
        taskDescriptor.setErrProcessorFactory((ExecutionDescriptor.InputProcessorFactory)errFactory);
        taskDescriptor.postBuild(new Runnable(){

            @Override
            public void run() {
                TestExecutionManager.getInstance().finish();
                convertor.refreshSession();
                TestSession newSession = convertor.refreshSession();
                outFactory.refreshSession(newSession);
                errFactory.refreshSession(newSession);
            }
        });
    }

    static interface DefaultTaskEvaluator {
        public boolean isDefault(RakeTask var1);
    }
}

