/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.AbilitiesPanel;
import org.netbeans.modules.mobility.project.ui.DecoratedNode;
import org.netbeans.modules.mobility.project.ui.ResourcesChildren;
import org.netbeans.modules.mobility.project.ui.actions.AddFolderAction;
import org.netbeans.modules.mobility.project.ui.actions.AddJarAction;
import org.netbeans.modules.mobility.project.ui.actions.AddLibraryAction;
import org.netbeans.modules.mobility.project.ui.actions.AddProjectAction;
import org.netbeans.modules.mobility.project.ui.actions.NodeAction;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.openide.actions.PasteAction;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class ResourcesNode
extends DecoratedNode
implements ChangeListener,
PropertyChangeListener,
Runnable {
    private static final String PLATFORM_ICON = "org/netbeans/modules/mobility/cldcplatform/resources/platform.gif";
    private final ResourcesChildren children;
    private final InstanceContent content;
    private final ProjectConfiguration config;
    private final L l = new L();

    protected ResourcesNode(J2MEProject project, ProjectConfiguration config) {
        this(project, config, new ResourcesChildren(project, config), new InstanceContent());
    }

    private ResourcesNode(J2MEProject project, ProjectConfiguration config, ResourcesChildren childFactory, InstanceContent content) {
        super(Children.create((ChildFactory)childFactory, (boolean)true), (Lookup)new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{project, AbilitiesPanel.hintInstance}), new AbstractLookup((AbstractLookup.Content)content)}));
        this.config = config;
        this.children = childFactory;
        this.content = content;
        assert (this.children != null);
        assert (project != null);
        content.set(Arrays.asList(config == null ? project.getConfigurationHelper().getActiveConfiguration() : config), null);
        this.setIconBaseWithExtension(PLATFORM_ICON);
        this.setDisplayName(NbBundle.getMessage(ResourcesNode.class, (String)"LBL_NodeCache_Resources"));
        this.change();
        AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        PropertyProvider pp = helper.getPropertyProvider("nbproject/project.properties");
        pp.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)pp));
        project.getConfigurationHelper().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)pp));
        helper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this.l, (Object)helper));
        JavaPlatformManager platformMgr = JavaPlatformManager.getDefault();
        platformMgr.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.l, (Object)platformMgr));
        LibraryManager lmgr = LibraryManager.getDefault();
        lmgr.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.l));
    }

    @Override
    protected boolean isBroken() {
        J2MEProject project = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        boolean broken = project.isConfigBroken(this.config);
        return broken;
    }

    private void change() {
        J2MEProject project = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        assert (project != null);
        ProjectConfiguration currConfig = this.config == null ? project.getConfigurationHelper().getActiveConfiguration() : this.config;
        this.content.set(currConfig == null ? Collections.EMPTY_SET : Collections.singleton(currConfig), null);
        EventQueue.invokeLater(this);
        this.children.update();
    }

    @Override
    public void run() {
        this.updateDisplayName();
    }

    private void updateDisplayName() {
        J2MEProject project = (J2MEProject)this.getLookup().lookup(J2MEProject.class);
        assert (project != null);
        boolean usingDefaultLibs = project.isUsingDefaultLibs(this.config);
        this.setValue("gray", usingDefaultLibs);
        if (usingDefaultLibs) {
            ProjectConfiguration def = project.getConfigurationHelper().getDefaultConfiguration();
            if (def != null) {
                String defaultCfgName = project.getConfigurationHelper().getDefaultConfiguration().getDisplayName();
                this.setDisplayName(NbBundle.getMessage(ResourcesNode.class, (String)"LBL_NodeCache_InheritedResources", (Object)defaultCfgName));
                return;
            }
            this.setValue("gray", true);
        }
        this.setDisplayName(NbBundle.getMessage(ResourcesNode.class, (String)"LBL_NodeCache_Resources"));
    }

    public Action[] getActions(boolean ignored) {
        Action[] actionArray;
        boolean gray = Boolean.TRUE.equals(this.getValue("gray"));
        if (gray) {
            actionArray = new Action[]{};
        } else {
            Action[] actionArray2 = new Action[6];
            actionArray2[0] = AddProjectAction.getStaticInstance();
            actionArray2[1] = AddJarAction.getStaticInstance();
            actionArray2[2] = AddFolderAction.getStaticInstance();
            actionArray2[3] = AddLibraryAction.getStaticInstance();
            actionArray2[4] = null;
            actionArray = actionArray2;
            actionArray2[5] = SystemAction.get(PasteAction.class);
        }
        return actionArray;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.change();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.change();
    }

    @Override
    public Image getIcon(int type) {
        Image libBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/libraries-badge.png");
        return ImageUtilities.mergeImages((Image)super.getIcon(type), (Image)libBadge, (int)6, (int)8);
    }

    private PasteType getPasteType(final Transferable tr, DataFlavor[] flavors) {
        String PRIMARY_TYPE = "application";
        String LIST_TYPE = "x-java-file-list";
        String DND_TYPE = "x-java-openide-nodednd";
        String MULTI_TYPE = "x-java-openide-multinode";
        final HashSet<VisualClassPathItem> set = new HashSet<VisualClassPathItem>();
        for (DataFlavor flavor : flavors) {
            class NDPasteType
            extends PasteType {
                NDPasteType() {
                }

                public Transferable paste() throws IOException {
                    if (set.size() != 0) {
                        NodeAction.pasteAction(set, (Node)ResourcesNode.this);
                        set.clear();
                    }
                    return tr;
                }
            }
            if (!"application".equals(flavor.getPrimaryType())) continue;
            if ("x-java-file-list".equals(flavor.getSubType())) {
                try {
                    List files = (List)tr.getTransferData(flavor);
                    if (files == null) continue;
                    for (File file : files) {
                        String s = file.getName().toLowerCase();
                        if (file.isDirectory()) {
                            file = FileUtil.normalizeFile((File)file);
                            set.add(new VisualClassPathItem(file, 4, null, file.getPath()));
                            continue;
                        }
                        if (s.endsWith(".zip") || s.endsWith(".jar")) {
                            file = FileUtil.normalizeFile((File)file);
                            set.add(new VisualClassPathItem(file, 0, null, file.getPath()));
                            continue;
                        }
                        set.clear();
                    }
                    return set.size() == 0 ? null : new NDPasteType();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }
            if ("x-java-openide-multinode".equals(flavor.getSubType())) {
                Node[] nodes = NodeTransfer.nodes((Transferable)tr, (int)3);
                if (nodes == null) {
                    return null;
                }
                for (Node node : nodes) {
                    if (node != null && node.getValue("resource") != null) {
                        VisualClassPathItem item = (VisualClassPathItem)node.getValue("VCPI");
                        if (item == null) continue;
                        set.add(item);
                        continue;
                    }
                    set.clear();
                }
                return set.size() == 0 ? null : new NDPasteType();
            }
            if (!"x-java-openide-nodednd".equals(flavor.getSubType())) continue;
            Node node = NodeTransfer.node((Transferable)tr, (int)3);
            if (node != null && node.getValue("resource") != null) {
                VisualClassPathItem item = (VisualClassPathItem)node.getValue("VCPI");
                if (item != null) {
                    set.add(item);
                }
            } else {
                set.clear();
                continue;
            }
            return set.size() == 0 ? null : new NDPasteType();
        }
        return null;
    }

    public PasteType getDropType(Transferable tr, int action, int index) {
        Boolean gray = Boolean.TRUE.equals(this.getValue("gray"));
        if (!gray.booleanValue()) {
            DataFlavor[] fr = tr.getTransferDataFlavors();
            PasteType type = this.getPasteType(tr, fr);
            return type;
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        PasteType pt = this.getDropType(t, 0, 0);
        if (pt != null) {
            s.add(pt);
        }
    }

    private class L
    implements PropertyChangeListener,
    AntProjectListener {
        private L() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ResourcesNode.this.checkBroken();
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            ResourcesNode.this.checkBroken();
        }

        public void propertiesChanged(AntProjectEvent ev) {
            ResourcesNode.this.checkBroken();
        }
    }
}

