/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.support.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class LibrariesChooser
extends JPanel {
    private JButton edit;
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public LibrariesChooser(String libraryType) {
        this.initComponents();
        this.initAccessibility();
        this.jList1.setPrototypeCellValue("0123456789012345678901234");
        this.jList1.setModel(new LibrariesListModel(libraryType));
        this.jList1.setCellRenderer(new LibraryRenderer());
    }

    public Library[] getSelectedLibraries() {
        Object[] selected = this.jList1.getSelectedValues();
        Library[] libraries = new Library[selected.length];
        System.arraycopy(selected, 0, libraries, 0, selected.length);
        return libraries;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.edit = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.jList1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LibrariesChooser.class, (String)"LAB_LIbCh_InstalledLibraries"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibrariesChooser.class, (String)"ACCESSIBLE_NAME_jLabel1"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibrariesChooser.class, (String)"ACCESSIBLE_DESCRIPTION_jLabel1"));
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LibrariesChooser.this.onDoubleClick(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.edit, (String)NbBundle.getMessage(LibrariesChooser.class, (String)"LBL_LibCh_Edit"));
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibrariesChooser.this.editLibraries(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 12, 12);
        this.add((Component)this.edit, gridBagConstraints);
        this.edit.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibrariesChooser.class, (String)"ACCESSIBLE_NAME_edit"));
        this.edit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibrariesChooser.class, (String)"ACCESSIBLE_DESCRIPTION_edit"));
    }

    private void initAccessibility() {
    }

    private void editLibraries(ActionEvent evt) {
        LibrariesCustomizer.showCustomizer((Library)((Library)this.jList1.getSelectedValue()));
    }

    private void onDoubleClick(MouseEvent evt) {
        RootPaneContainer rpc;
        JButton okButton;
        Container w;
        if (!evt.isPopupTrigger() && evt.getClickCount() > 1 && this.jList1.getSelectedValue() != null && (w = this.getTopLevelAncestor()) instanceof RootPaneContainer && (okButton = (rpc = (RootPaneContainer)((Object)w)).getRootPane().getDefaultButton()) != null && okButton.isEnabled()) {
            okButton.doClick();
        }
    }

    private static final class LibraryRenderer
    extends DefaultListCellRenderer {
        private LibraryRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayName = value instanceof Library ? ((Library)value).getDisplayName() : (value instanceof String ? (String)value : value.toString());
            return super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
        }
    }

    private final class LibrariesListModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private Library[] cache;
        private final String libraryType;

        public LibrariesListModel(String libraryType) {
            this.libraryType = libraryType;
            LibraryManager manager = LibraryManager.getDefault();
            manager.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)manager));
        }

        @Override
        public synchronized int getSize() {
            if (this.cache == null) {
                this.cache = this.getLibraries();
            }
            return this.cache.length;
        }

        @Override
        public synchronized Object getElementAt(int index) {
            if (this.cache == null) {
                this.cache = this.getLibraries();
            }
            if (index >= 0 && index < this.cache.length) {
                return this.cache[index];
            }
            return null;
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            this.cache = null;
        }

        private Library[] getLibraries() {
            Library[] libs = LibraryManager.getDefault().getLibraries();
            ArrayList<Library> filtered = new ArrayList<Library>();
            for (int i = 0; libs != null && i < libs.length; ++i) {
                if (this.libraryType != null && !this.libraryType.equals(libs[i].getType())) continue;
                filtered.add(libs[i]);
            }
            libs = filtered.toArray(new Library[filtered.size()]);
            Arrays.sort(libs, new Comparator<Library>(){

                @Override
                public int compare(Library o1, Library o2) {
                    String name1 = o1.getDisplayName();
                    String name2 = o2.getDisplayName();
                    return name1.compareToIgnoreCase(name2);
                }
            });
            return libs;
        }
    }
}

