/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext.preprocessor;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.netbeans.mobility.antext.preprocessor.LineParser;
import org.netbeans.mobility.antext.preprocessor.PPBlockInfo;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.mobility.antext.preprocessor.PPToken;
import org.netbeans.mobility.antext.preprocessor.PreprocessorException;

public final class CommentingPreProcessor
implements Runnable {
    static final String DEFAULT_COMMENT = "//# ";
    private final Source src;
    private final Destination dest;
    private final Stack<PPBlockInfo> stack;
    private final AbilitiesEvaluator eval;
    private final ArrayList<PPBlockInfo> blockList;
    private final ArrayList<PPLine> lines;
    private PPLine line;
    private LineParser lp;
    protected PPBlockInfo stackTop;

    public CommentingPreProcessor(Source src, Destination dest, String abilities) {
        this(src, dest, CommentingPreProcessor.decodeAbilitiesMap(abilities));
    }

    public CommentingPreProcessor(Source src, Destination dest, Map<String, String> abilities) {
        this.src = src;
        this.dest = dest;
        this.blockList = new ArrayList();
        this.lines = new ArrayList();
        this.stack = new Stack();
        this.stackTop = null;
        this.eval = new MapEvaluator(abilities);
        this.line = null;
    }

    public ArrayList<PPLine> getLines() {
        return this.lines;
    }

    public ArrayList<PPBlockInfo> getBlockList() {
        return this.blockList;
    }

    @Override
    public void run() {
        Exception e = null;
        Reader r = null;
        try {
            r = this.src.createReader();
            this.parse(r);
        }
        catch (Exception ex) {
            while (this.lp.hasMoreLines()) {
                this.lines.add(this.lp.nextLine());
            }
            e = ex;
        }
        Writer w = null;
        if (this.dest != null) {
            try {
                w = this.dest.createWriter(e == null && !this.hasErrors() && this.conditionIsTrue());
                this.writeOutput(w);
            }
            catch (IOException ioe) {
                throw new PreprocessorException("IOException during write", ioe);
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException ioe) {
                        throw new PreprocessorException("IOException during source reader close", ioe);
                    }
                }
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException ioe) {
                        throw new PreprocessorException("IOException during detination writer close/flush", ioe);
                    }
                }
            }
        }
        if (e != null) {
            if (e instanceof PreprocessorException) {
                e.fillInStackTrace();
                throw (PreprocessorException)e;
            }
            throw new PreprocessorException("Critical Preprocessor Exception", e);
        }
    }

    private void parse(Reader r) {
        this.lp = new LineParser(r, this.eval);
        while (this.lp.hasMoreLines()) {
            this.line = this.lp.nextLine();
            this.lines.add(this.line);
            boolean reduceDebug = this.debugOnTop();
            switch (this.line.getType()) {
                case 0: 
                case 2: 
                case 3: 
                case 8: 
                case 9: 
                case 13: 
                case 17: {
                    this.push(new PPBlockInfo(this.stackTop, this.line, this.line.hasValue(), this.line.getValue(), null));
                    this.line.setBlock(this.stackTop);
                    break;
                }
                case 1: {
                    this.line.setBlock(this.stackTop);
                    if (this.stackTop != null && this.stackTop.getType() != 13 && this.stackTop.getType() != 9) {
                        this.pop(true);
                        break;
                    }
                    this.line.addError("ERR_redundant_endif");
                    break;
                }
                case 14: {
                    this.line.setBlock(this.stackTop);
                    if (this.stackTop != null && this.stackTop.getType() == 13) {
                        this.pop(true);
                        break;
                    }
                    this.line.addError("ERR_redundant_old_block_end");
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (this.stackTop != null && this.stackTop.getType() != 13 && this.stackTop.getType() != 9 && this.stackTop.getType() != 4) {
                        PPBlockInfo ifChainAncestor = this.stackTop;
                        this.pop(false);
                        this.push(new PPBlockInfo(this.stackTop, this.line, this.line.hasValue(), this.line.getValue(), ifChainAncestor));
                    } else {
                        this.line.addError("ERR_redundant_else");
                    }
                    this.line.setBlock(this.stackTop);
                    break;
                }
                case 10: {
                    this.line.setBlock(this.stackTop);
                    if (this.stackTop != null && this.stackTop.getType() == 9) {
                        this.pop(true);
                        break;
                    }
                    this.line.addError("ERR_redundant_enddebug");
                    break;
                }
                default: {
                    this.line.setBlock(this.stackTop);
                }
            }
            if (!reduceDebug || !this.debugOnTop()) continue;
            this.pop(true);
        }
        while (this.stackTop != null) {
            if (this.stackTop.getType() != 17) {
                this.stackTop.addError("ERR_unterminated_block");
            }
            this.pop(false);
        }
    }

    private void writeOutput(Writer w) throws IOException {
        for (PPLine l : this.lines) {
            PPToken token;
            Iterator<PPToken> tk = l.getTokens().iterator();
            PPBlockInfo b = l.getBlock();
            if (b == null || b.isToBeCommented()) {
                if (b == null || b.isActive()) {
                    if (l.getType() == 15) {
                        token = tk.next();
                        if (b == null && "//--".equals(token.getText())) {
                            if (w != null) {
                                w.write(token.getText());
                            }
                        } else {
                            this.dest.doRemove(token.getLine(), token.getColumn(), token.getText().length());
                        }
                    }
                } else if (l.getType() == 16) {
                    this.dest.doInsert(l.getLineNumber(), DEFAULT_COMMENT);
                    if (w != null) {
                        w.write(DEFAULT_COMMENT);
                    }
                }
            }
            if (w == null) continue;
            while (tk.hasNext()) {
                token = tk.next();
                w.write(token.getPadding());
                w.write(token.getText());
            }
        }
    }

    private void push(PPBlockInfo b) {
        this.blockList.add(b);
        this.stack.push(this.stackTop);
        this.stackTop = b;
    }

    private void pop(boolean hasFooter) {
        if (this.stack.isEmpty()) {
            this.stackTop = null;
        } else {
            this.stackTop.setEndLine(this.line.getLineNumber() - (hasFooter ? 0 : 1));
            this.stackTop.setHasFooter(hasFooter);
            this.stackTop = this.stack.pop();
            if (this.debugOnTop()) {
                this.pop(false);
            }
        }
    }

    private boolean hasErrors() {
        for (PPLine ppl : this.lines) {
            if (!ppl.hasErrors()) continue;
            return true;
        }
        return false;
    }

    private boolean conditionIsTrue() {
        if (this.lines.size() == 0) {
            return true;
        }
        PPLine l = this.lines.get(0);
        return l.getType() != 17 || !l.hasValue() || l.getValue();
    }

    private boolean debugOnTop() {
        return this.stackTop != null && this.stackTop.getType() == 8;
    }

    public static String encodeAbilitiesMap(Map<String, String> abilities) {
        StringBuffer sb = new StringBuffer();
        if (abilities != null) {
            for (Map.Entry<String, String> me : abilities.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(me.getKey());
                String val = me.getValue();
                if (val == null) continue;
                sb.append('=');
                for (int i = 0; i < val.length(); ++i) {
                    char c = val.charAt(i);
                    if (c == '\\' || c == ',') {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static Map<String, String> decodeAbilitiesMap(String abilities) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (abilities != null) {
            StringBuffer sb = new StringBuffer();
            boolean backslash = false;
            String key = null;
            for (int i = 0; i < abilities.length(); ++i) {
                char c = abilities.charAt(i);
                if (key == null) {
                    if (c == '=') {
                        key = sb.toString();
                        sb.setLength(0);
                        continue;
                    }
                    if (c == ',') {
                        map.put(sb.toString(), null);
                        sb.setLength(0);
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (backslash) {
                    if (c != '\\' && c != ',') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    backslash = false;
                    continue;
                }
                if (c == '\\') {
                    backslash = true;
                    continue;
                }
                if (c == ',') {
                    map.put(key, sb.toString());
                    key = null;
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
            }
            if (backslash) {
                sb.append('\\');
            }
            if (key == null) {
                map.put(sb.toString(), null);
            } else {
                map.put(key, sb.toString());
            }
        }
        map.remove("");
        return map;
    }

    public static void main(final String[] args) throws Exception {
        new CommentingPreProcessor(new Source(){

            @Override
            public Reader createReader() throws IOException {
                return new FileReader(args[0]);
            }
        }, new Destination(){

            @Override
            public void doInsert(int line, String s) throws IOException {
                System.err.print(String.valueOf(line) + "+, ");
            }

            @Override
            public void doRemove(int line, int column, int length) throws IOException {
                System.err.print(String.valueOf(line) + "-, ");
            }

            @Override
            public Writer createWriter(boolean validOutput) throws IOException {
                return new StringWriter();
            }
        }, Collections.singletonMap("aaa", null)).run();
    }

    private class MapEvaluator
    extends HashMap<String, String>
    implements AbilitiesEvaluator {
        public MapEvaluator() {
        }

        public MapEvaluator(Map<String, String> m) {
            super(m);
        }

        @Override
        public boolean isAbilityDefined(String abilityName) {
            return this.containsKey(abilityName);
        }

        @Override
        public String getAbilityValue(String abilityName) {
            return (String)this.get(abilityName);
        }

        @Override
        public void requestDefineAbility(String abilityName, String value) {
            if (!(CommentingPreProcessor.this.stackTop != null && CommentingPreProcessor.this.stackTop.isToBeCommented() && !CommentingPreProcessor.this.stackTop.isActive() || this.containsKey(abilityName))) {
                this.put(abilityName, value);
            }
        }

        @Override
        public void requestUndefineAbility(String abilityName) {
            if (CommentingPreProcessor.this.stackTop == null || !CommentingPreProcessor.this.stackTop.isToBeCommented() || CommentingPreProcessor.this.stackTop.isActive()) {
                this.remove(abilityName);
            }
        }
    }

    public static interface Destination {
        public Writer createWriter(boolean var1) throws IOException;

        public void doInsert(int var1, String var2) throws IOException;

        public void doRemove(int var1, int var2, int var3) throws IOException;
    }

    public static interface Source {
        public Reader createReader() throws IOException;
    }

    public static interface AbilitiesEvaluator {
        public boolean isAbilityDefined(String var1);

        public String getAbilityValue(String var1);

        public void requestDefineAbility(String var1, String var2);

        public void requestUndefineAbility(String var1);
    }
}

