/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.java.invokers;

import java.util.Arrays;
import java.util.Map;
import org.jruby.nb.RubyModule;
import org.jruby.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaCallable;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class RubyToJavaInvoker
extends JavaMethod {
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected JavaCallable javaCallable;
    protected JavaCallable[][] javaCallables;
    protected Map cache;
    protected volatile boolean initialized;

    RubyToJavaInvoker(RubyModule host) {
        super(host, Visibility.PUBLIC);
    }

    void raiseNoMatchingCallableError(String name, IRubyObject proxy, Object ... args) {
        int len = args.length;
        Object[] argTypes = new Class[args.length];
        for (int i = 0; i < len; ++i) {
            argTypes[i] = args[i].getClass();
        }
        throw proxy.getRuntime().newNameError("no " + name + " with arguments matching " + Arrays.toString(argTypes) + " on object " + proxy.getMetaClass(), null);
    }

    protected JavaCallable findCallable(IRubyObject self, String name, IRubyObject[] args, int arity) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (arity > this.javaCallables.length || (callablesForArity = this.javaCallables[arity]) == null) {
                this.raiseNoMatchingCallableError(name, self, args, 0);
            }
            callable = Java.matchingCallableArityN(self, this.cache, callablesForArity, args, arity);
        } else if (callable.getParameterTypes().length != args.length) {
            throw self.getRuntime().newArgumentError(args.length, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityZero(IRubyObject self, String name) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length == 0 || (callablesForArity = this.javaCallables[0]) == null) {
                this.raiseNoMatchingCallableError(name, self, IRubyObject.NULL_ARRAY, 0);
            }
            callable = callablesForArity[0];
        } else if (callable.getParameterTypes().length != 0) {
            throw self.getRuntime().newArgumentError(0, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityOne(IRubyObject self, String name, IRubyObject arg0) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length < 1 || (callablesForArity = this.javaCallables[1]) == null) {
                this.raiseNoMatchingCallableError(name, self, arg0);
            }
            callable = Java.matchingCallableArityOne(self, this.cache, callablesForArity, arg0);
        } else if (callable.getParameterTypes().length != 1) {
            throw self.getRuntime().newArgumentError(1, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityTwo(IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length <= 2 || (callablesForArity = this.javaCallables[2]) == null) {
                this.raiseNoMatchingCallableError(name, self, arg0, arg1);
            }
            callable = Java.matchingCallableArityTwo(self, this.cache, callablesForArity, arg0, arg1);
        } else if (callable.getParameterTypes().length != 2) {
            throw self.getRuntime().newArgumentError(2, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityThree(IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length <= 3 || (callablesForArity = this.javaCallables[3]) == null) {
                this.raiseNoMatchingCallableError(name, self, arg0, arg1, arg2);
            }
            callable = Java.matchingCallableArityThree(self, this.cache, callablesForArity, arg0, arg1, arg2);
        } else if (callable.getParameterTypes().length != 3) {
            throw self.getRuntime().newArgumentError(3, callable.getParameterTypes().length);
        }
        return callable;
    }

    protected JavaCallable findCallableArityFour(IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        JavaCallable callable = this.javaCallable;
        if (callable == null) {
            JavaCallable[] callablesForArity = null;
            if (this.javaCallables.length <= 4 || (callablesForArity = this.javaCallables[4]) == null) {
                this.raiseNoMatchingCallableError(name, self, arg0, arg1, arg2, arg3);
            }
            callable = Java.matchingCallableArityFour(self, this.cache, callablesForArity, arg0, arg1, arg2, arg3);
        } else if (callable.getParameterTypes().length != 4) {
            throw self.getRuntime().newArgumentError(4, callable.getParameterTypes().length);
        }
        return callable;
    }
}

