/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.trafo;

import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Vector3D;

public final class Quaternion {
    private float x;
    private float y;
    private float z;
    private float w;

    public Quaternion(Vector3D from, Vector3D to) {
        from.normalize();
        to.normalize();
        this.x = from.y * to.z - from.z * to.y;
        this.y = from.z * to.x - from.x * to.z;
        this.z = from.x * to.y - from.y * to.x;
        this.w = from.x * to.x + from.y * to.y + from.z * to.z;
    }

    public Quaternion(Quaternion quat) {
        this(quat.x, quat.y, quat.z, quat.w);
    }

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion() {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4D getMatrix() {
        float norm = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        float scale = norm > 0.0f ? 2.0f / norm : 0.0f;
        float xs = this.x * scale;
        float ys = this.y * scale;
        float zs = this.z * scale;
        float wx = this.w * xs;
        float wy = this.w * ys;
        float wz = this.w * zs;
        float xx = this.x * xs;
        float xy = this.x * ys;
        float xz = this.x * zs;
        float yy = this.y * ys;
        float yz = this.y * zs;
        float zz = this.z * zs;
        return new Matrix4D(1.0f - yy - zz, xy - wz, xz + wy, 0.0f, xy + wz, 1.0f - xx - zz, yz - wx, 0.0f, xz - wy, yz + wx, 1.0f - xx - yy, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quaternion mult(Quaternion quat) {
        return new Quaternion(this.w * quat.x + this.x * quat.w + this.y * quat.z - this.z * quat.y, this.w * quat.y + this.y * quat.w + this.z * quat.x - this.x * quat.z, this.w * quat.z + this.z * quat.w + this.x * quat.y - this.y * quat.x, this.w * quat.w - this.x * quat.x - this.y * quat.y - this.z * quat.z);
    }

    public void multBy(Quaternion quat) {
        float nw = this.w * quat.w - this.x * quat.x - this.y * quat.y - this.z * quat.z;
        float nx = this.w * quat.x + this.x * quat.w + this.y * quat.z - this.z * quat.y;
        float ny = this.w * quat.y + this.y * quat.w + this.z * quat.x - this.x * quat.z;
        float nz = this.w * quat.z + this.z * quat.w + this.x * quat.y - this.y * quat.x;
        this.w = nw;
        this.x = nx;
        this.y = ny;
        this.z = nz;
    }

    public String toString() {
        return "[#" + this.x + "," + this.y + "," + this.z + "," + this.w + "#]";
    }
}

