/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.netbeans.core.output2.NbIO;

class PairMap {
    private String[] keys = new String[10];
    Object[] vals = new Object[10];
    int last = -1;
    private boolean weak = false;
    private boolean pruning = false;

    PairMap() {
    }

    public synchronized void clear() {
        this.keys = new String[10];
        this.vals = new Object[10];
        this.last = -1;
    }

    public synchronized int size() {
        if (this.weak) {
            return this.prune();
        }
        return this.last + 1;
    }

    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void setWeak(boolean bl) {
        if (this.weak != bl) {
            this.weak = bl;
            for (int i = 0; i <= this.last; ++i) {
                this.vals[i] = this.weak ? new WeakReference<Object>(this.vals[i]) : ((WeakReference)this.vals[i]).get();
            }
            if (!this.weak) {
                this.prune();
            }
        }
    }

    public synchronized void add(String string, NbIO nbIO) {
        if (this.last == this.keys.length - 1) {
            this.growArrays();
        }
        ++this.last;
        this.keys[this.last] = string;
        this.vals[this.last] = nbIO;
    }

    public synchronized NbIO get(String string, boolean bl) {
        if (this.last < 0) {
            return null;
        }
        boolean bl2 = false;
        for (int i = this.last; i >= 0; --i) {
            if (!this.keys[i].equals(string)) continue;
            NbIO nbIO = this.getValue(i);
            bl2 |= nbIO == null;
            if (nbIO == null || bl && (!bl || !nbIO.isStreamClosed())) continue;
            return nbIO;
        }
        if (bl2) {
            this.prune();
        }
        return null;
    }

    public boolean containsValue(NbIO nbIO) {
        if (this.last < 0) {
            return false;
        }
        for (int i = this.last; i >= 0; --i) {
            if (this.getValue(i) != nbIO) continue;
            return true;
        }
        return false;
    }

    public synchronized NbIO get(String string) {
        return this.get(string, false);
    }

    public synchronized String remove(NbIO nbIO) {
        int n = this.indexOfVal(nbIO);
        if (n == -1) {
            return null;
        }
        String string = this.keys[n];
        this.removeIndex(n);
        return string;
    }

    public synchronized NbIO remove(String string) {
        int n = this.indexOfKey(string);
        if (n == -1) {
            return null;
        }
        NbIO nbIO = this.getValue(n);
        this.removeIndex(n);
        return nbIO;
    }

    private NbIO getValue(int n) {
        NbIO nbIO;
        if (n > this.last) {
            throw new ArrayIndexOutOfBoundsException("Tried to fetch item " + n + " but map only contains " + (this.last + 1) + " elements");
        }
        Object object = this.vals[n];
        if (this.weak) {
            nbIO = (NbIO)((WeakReference)this.vals[n]).get();
            if (nbIO == null && !this.pruning) {
                this.removeIndex(n);
            }
        } else {
            nbIO = (NbIO)object;
        }
        return nbIO;
    }

    public void setValue(int n, NbIO nbIO) {
        this.vals[n] = this.weak ? new WeakReference<NbIO>(nbIO) : nbIO;
    }

    private void removeIndex(int n) {
        if (n < 0 || n > this.last) {
            throw new ArrayIndexOutOfBoundsException("Trying to remove element " + n + " but map only contains " + (this.last + 1) + " elements");
        }
        if (n == this.last) {
            this.keys[n] = null;
            this.vals[n] = null;
        } else {
            this.keys[n] = this.keys[this.last];
            this.vals[n] = this.vals[this.last];
            this.vals[this.last] = null;
            this.keys[this.last] = null;
        }
        --this.last;
    }

    private int indexOfKey(String string) {
        for (int i = this.last; i >= 0; --i) {
            if (!this.keys[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    private int indexOfVal(NbIO nbIO) {
        for (int i = this.last; i >= 0; --i) {
            if (this.vals[i] != nbIO) continue;
            return i;
        }
        return -1;
    }

    private void growArrays() {
        String[] stringArray = new String[this.keys.length * 2];
        NbIO[] nbIOArray = new NbIO[this.vals.length * 2];
        System.arraycopy(this.keys, 0, stringArray, 0, this.last + 1);
        System.arraycopy(this.vals, 0, nbIOArray, 0, this.last + 1);
        this.keys = stringArray;
        this.vals = nbIOArray;
    }

    private int prune() {
        int n;
        int n2;
        this.pruning = true;
        int n3 = n2 = this.last + 1;
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        for (n = this.last; n >= 0; --n) {
            if (this.getValue(n) != null) continue;
            nArray[n] = n;
            --n3;
        }
        if (n3 != n2) {
            for (n = nArray.length - 1; n >= 0; --n) {
                if (nArray[n] == -1) continue;
                this.removeIndex(nArray[n]);
            }
        }
        this.pruning = false;
        return n3;
    }
}

