/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.filterrows;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.filterrows.FilterRows;
import org.pentaho.di.trans.steps.filterrows.FilterRowsData;
import org.pentaho.di.trans.steps.filterrows.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private Condition condition = new Condition();
    private String sendTrueStepname;
    private StepMeta sendTrueStep;
    private String sendFalseStepname;
    private StepMeta sendFalseStep;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String getSendFalseStepname() {
        if (this.sendFalseStep != null && this.sendFalseStep.getName() != null && this.sendFalseStep.getName().length() > 0) {
            return this.sendFalseStep.getName();
        }
        return this.sendFalseStepname;
    }

    public String getSendTrueStepname() {
        if (this.sendTrueStep != null && this.sendTrueStep.getName() != null && this.sendTrueStep.getName().length() > 0) {
            return this.sendTrueStep.getName();
        }
        return this.sendTrueStepname;
    }

    public void setSendFalseStepname(String sendFalseStepname) {
        this.sendFalseStepname = sendFalseStepname;
    }

    public void setSendTrueStepname(String sendTrueStepname) {
        this.sendTrueStepname = sendTrueStepname;
    }

    public StepMeta getSendFalseStep() {
        return this.sendFalseStep;
    }

    public StepMeta getSendTrueStep() {
        return this.sendTrueStep;
    }

    public void setSendFalseStep(StepMeta sendFalseStep) {
        this.sendFalseStep = sendFalseStep;
    }

    public void setSendTrueStep(StepMeta sendTrueStep) {
        this.sendTrueStep = sendTrueStep;
    }

    public void allocate() {
        this.condition = new Condition();
    }

    @Override
    public Object clone() {
        FilterRowsMeta retval = (FilterRowsMeta)super.clone();
        retval.condition = this.condition != null ? (Condition)this.condition.clone() : null;
        return retval;
    }

    @Override
    public String getXML() throws KettleException {
        StringBuffer retval = new StringBuffer(200);
        retval.append(XMLHandler.addTagValue((String)"send_true_to", (String)this.getSendTrueStepname()));
        retval.append(XMLHandler.addTagValue((String)"send_false_to", (String)this.getSendFalseStepname()));
        retval.append("    <compare>").append(Const.CR);
        if (this.condition != null) {
            retval.append(this.condition.getXML());
        }
        retval.append("    </compare>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.sendFalseStepname = XMLHandler.getTagValue((Node)stepnode, (String)"send_false_to");
            this.sendTrueStepname = XMLHandler.getTagValue((Node)stepnode, (String)"send_true_to");
            Node compare = XMLHandler.getSubNode((Node)stepnode, (String)"compare");
            Node condnode = XMLHandler.getSubNode((Node)compare, (String)"condition");
            if (condnode != null) {
                this.condition = new Condition(condnode);
            } else {
                this.condition = new Condition();
                int nrkeys = XMLHandler.countNodes((Node)compare, (String)"key");
                if (nrkeys == 1) {
                    Node knode = XMLHandler.getSubNodeByNr((Node)compare, (String)"key", (int)0);
                    String key = XMLHandler.getTagValue((Node)knode, (String)"name");
                    String value = XMLHandler.getTagValue((Node)knode, (String)"value");
                    String field = XMLHandler.getTagValue((Node)knode, (String)"field");
                    String comparator = XMLHandler.getTagValue((Node)knode, (String)"condition");
                    this.condition.setOperator(0);
                    this.condition.setLeftValuename(key);
                    this.condition.setFunction(Condition.getFunction(comparator));
                    this.condition.setRightValuename(field);
                    this.condition.setRightExact(new ValueMetaAndData("value", (Object)value));
                } else {
                    for (int i = 0; i < nrkeys; ++i) {
                        Node knode = XMLHandler.getSubNodeByNr((Node)compare, (String)"key", (int)i);
                        String key = XMLHandler.getTagValue((Node)knode, (String)"name");
                        String value = XMLHandler.getTagValue((Node)knode, (String)"value");
                        String field = XMLHandler.getTagValue((Node)knode, (String)"field");
                        String comparator = XMLHandler.getTagValue((Node)knode, (String)"condition");
                        Condition subc = new Condition();
                        if (i > 0) {
                            subc.setOperator(1);
                        } else {
                            subc.setOperator(0);
                        }
                        subc.setLeftValuename(key);
                        subc.setFunction(Condition.getFunction(comparator));
                        subc.setRightValuename(field);
                        subc.setRightExact(new ValueMetaAndData("value", (Object)value));
                        this.condition.addCondition(subc);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("FilterRowsMeta.Exception..UnableToLoadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.allocate();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.allocate();
            this.sendTrueStepname = rep.getStepAttributeString(id_step, "send_true_to");
            this.sendFalseStepname = rep.getStepAttributeString(id_step, "send_false_to");
            long id_condition = rep.getStepAttributeInteger(id_step, 0, "id_condition");
            if (id_condition > 0L) {
                this.condition = new Condition(rep, id_condition);
            } else {
                int nrkeys = rep.countNrStepAttributes(id_step, "compare_name");
                if (nrkeys == 1) {
                    String key = rep.getStepAttributeString(id_step, 0, "compare_name");
                    String comparator = rep.getStepAttributeString(id_step, 0, "compare_condition");
                    String value = rep.getStepAttributeString(id_step, 0, "compare_value");
                    String field = rep.getStepAttributeString(id_step, 0, "compare_field");
                    this.condition = new Condition();
                    this.condition.setOperator(0);
                    this.condition.setLeftValuename(key);
                    this.condition.setFunction(Condition.getFunction(comparator));
                    this.condition.setRightValuename(field);
                    this.condition.setRightExact(new ValueMetaAndData("value", (Object)value));
                } else {
                    this.condition = new Condition();
                    for (int i = 0; i < nrkeys; ++i) {
                        String key = rep.getStepAttributeString(id_step, i, "compare_name");
                        String comparator = rep.getStepAttributeString(id_step, i, "compare_condition");
                        String value = rep.getStepAttributeString(id_step, i, "compare_value");
                        String field = rep.getStepAttributeString(id_step, i, "compare_field");
                        Condition subc = new Condition();
                        if (i > 0) {
                            subc.setOperator(1);
                        } else {
                            subc.setOperator(0);
                        }
                        subc.setLeftValuename(key);
                        subc.setFunction(Condition.getFunction(comparator));
                        subc.setRightValuename(field);
                        subc.setRightExact(new ValueMetaAndData("value", (Object)value));
                        this.condition.addCondition(subc);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("FilterRowsMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            if (this.condition != null) {
                this.condition.saveRep(rep);
                rep.saveStepAttribute(id_transformation, id_step, "id_condition", this.condition.getID());
                rep.insertTransStepCondition(id_transformation, id_step, this.condition.getID());
                rep.saveStepAttribute(id_transformation, id_step, "send_true_to", this.getSendTrueStepname());
                rep.saveStepAttribute(id_transformation, id_step, "send_false_to", this.getSendFalseStepname());
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("FilterRowsMeta.Exception.UnableToSaveStepInfoToRepository") + id_step, (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.sendTrueStep = StepMeta.findStep(steps, this.sendTrueStepname);
        this.sendFalseStep = StepMeta.findStep(steps, this.sendFalseStepname);
    }

    @Override
    public boolean chosesTargetSteps() {
        return this.sendTrueStep != null && this.sendFalseStep != null;
    }

    @Override
    public String[] getTargetSteps() {
        if (this.chosesTargetSteps()) {
            return new String[]{this.getSendTrueStepname(), this.getSendFalseStepname()};
        }
        return null;
    }

    @Override
    public void setTargetSteps(StepMeta[] targetSteps) {
        if (targetSteps != null && targetSteps.length > 0) {
            this.sendTrueStep = targetSteps[0];
            this.sendFalseStep = targetSteps[1];
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        int falseTargetIdx;
        int trueTargetIdx;
        CheckResult cr;
        String error_message = "";
        if (this.getSendTrueStepname() != null && this.getSendFalseStepname() != null) {
            cr = new CheckResult(1, Messages.getString("FilterRowsMeta.CheckResult.BothTrueAndFalseStepSpecified"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else if (this.getSendTrueStepname() == null && this.getSendFalseStepname() == null) {
            cr = new CheckResult(1, Messages.getString("FilterRowsMeta.CheckResult.NeitherTrueAndFalseStepSpecified"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("FilterRowsMeta.CheckResult.PlsSpecifyBothTrueAndFalseStep"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.getSendTrueStepname() != null && (trueTargetIdx = Const.indexOfString((String)this.getSendTrueStepname(), (String[])output)) < 0) {
            cr = new CheckResult(4, Messages.getString("FilterRowsMeta.CheckResult.TargetStepInvalid", "true", this.getSendTrueStepname()), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.getSendFalseStepname() != null && (falseTargetIdx = Const.indexOfString((String)this.getSendFalseStepname(), (String[])output)) < 0) {
            cr = new CheckResult(4, Messages.getString("FilterRowsMeta.CheckResult.TargetStepInvalid", "false", this.getSendFalseStepname()), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        cr = this.condition.isEmpty() ? new CheckResult(4, Messages.getString("FilterRowsMeta.CheckResult.NoConditionSpecified"), (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("FilterRowsMeta.CheckResult.ConditionSpecified"), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, Messages.getString("FilterRowsMeta.CheckResult.StepReceivingFields", prev.size() + ""), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            boolean first = true;
            error_message = "";
            boolean error_found = false;
            String[] key = this.condition.getUsedFields();
            for (int i = 0; i < key.length; ++i) {
                ValueMetaInterface v = prev.searchValueMeta(key[i]);
                if (v != null) continue;
                if (first) {
                    first = false;
                    error_message = error_message + Messages.getString("FilterRowsMeta.CheckResult.FieldsNotFoundFromPreviousStep") + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + key[i] + Const.CR;
            }
            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, Messages.getString("FilterRowsMeta.CheckResult.AllFieldsFoundInInputStream"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = Messages.getString("FilterRowsMeta.CheckResult.CouldNotReadFieldsFromPreviousStep") + Const.CR;
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("FilterRowsMeta.CheckResult.StepReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("FilterRowsMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new FilterRows(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FilterRowsData();
    }
}

