/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.util.SQLPowerUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExceptionReport {
    private static final Logger logger = Logger.getLogger(ExceptionReport.class);
    private static final int MAX_REPORT_TRIES = 10;
    private static int numReportsThisRun = 0;
    private String applicationVersion;
    private static final long applicationStartupTime = System.currentTimeMillis();
    private String applicationName;
    private long totalMem;
    private long freeMem;
    private long maxMem;
    private String jvmVendor;
    private String jvmVersion;
    private String osArch;
    private String osName;
    private String osVersion;
    private String remarks;
    private Throwable exception;
    private String reportUrl;
    private Map<String, String> additionalInfo = new HashMap<String, String>();

    public static void init() {
        logger.debug((Object)("Remembering app startup time = " + applicationStartupTime));
    }

    public ExceptionReport(Throwable exception, String reportURL, String applicationVersion, String appName) {
        this.exception = exception;
        this.reportUrl = reportURL;
        this.applicationVersion = applicationVersion;
        this.applicationName = appName;
        this.totalMem = Runtime.getRuntime().totalMemory();
        this.freeMem = Runtime.getRuntime().freeMemory();
        this.maxMem = Runtime.getRuntime().maxMemory();
        this.jvmVendor = System.getProperty("java.vendor");
        this.jvmVersion = System.getProperty("java.version");
        this.osArch = System.getProperty("os.arch");
        this.osName = System.getProperty("os.name");
        this.osVersion = System.getProperty("os.version");
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        xml.append("\n<application-exception-report version=\"1.0\">");
        this.appendNestedExceptions(xml, this.exception);
        xml.append("\n <application-name>").append(SQLPowerUtils.escapeXML(this.applicationName)).append("</application-name>");
        xml.append("\n <application-version>").append(SQLPowerUtils.escapeXML(this.applicationVersion)).append("</application-version>");
        xml.append("\n <application-uptime>").append(ExceptionReport.getApplicationUptime()).append("</application-uptime>");
        xml.append("\n <total-mem>").append(this.totalMem).append("</total-mem>");
        xml.append("\n <free-mem>").append(this.freeMem).append("</free-mem>");
        xml.append("\n <max-mem>").append(this.maxMem).append("</max-mem>");
        xml.append("\n <jvm vendor=\"").append(SQLPowerUtils.escapeXML(this.jvmVendor)).append("\" version=\"").append(SQLPowerUtils.escapeXML(this.jvmVersion)).append("\" />");
        xml.append("\n <os arch=\"").append(SQLPowerUtils.escapeXML(this.osArch)).append("\" name=\"").append(SQLPowerUtils.escapeXML(this.osName)).append("\" version=\"").append(SQLPowerUtils.escapeXML(this.osVersion)).append("\" />");
        for (Map.Entry<String, String> ent : this.additionalInfo.entrySet()) {
            xml.append("\n <application-specific property=\"" + SQLPowerUtils.escapeXML(ent.getKey()) + "\">").append(SQLPowerUtils.escapeXML(ent.getValue())).append("</application-specific>");
        }
        xml.append("\n <remarks>").append(SQLPowerUtils.escapeXML(this.remarks)).append("</remarks>");
        xml.append("\n</application-exception-report>");
        xml.append("\n");
        return xml.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Exception Report: ");
        sb.append(this.exception);
        sb.append(" ");
        sb.append(this.remarks);
        return sb.toString();
    }

    private void appendNestedExceptions(StringBuffer xml, Throwable exception) {
        if (exception == null) {
            return;
        }
        xml.append("\n <exception class=\"").append(SQLPowerUtils.escapeXML(exception.getClass().getName())).append("\" message=\"").append(SQLPowerUtils.escapeXML(exception.getMessage())).append("\">");
        for (StackTraceElement ste : exception.getStackTrace()) {
            xml.append("\n  <trace-element class=\"").append(SQLPowerUtils.escapeXML(ste.getClassName())).append("\" method=\"").append(SQLPowerUtils.escapeXML(ste.getMethodName())).append("\" file=\"").append(SQLPowerUtils.escapeXML(ste.getFileName())).append("\" line=\"").append(ste.getLineNumber()).append("\" />");
        }
        this.appendNestedExceptions(xml, exception.getCause());
        xml.append("\n </exception>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        logger.debug((Object)("posting report: " + this.toString()));
        if (numReportsThisRun++ > 10) {
            logger.info((Object)String.format("Not logging this error, threshold of %d exceeded", 10));
            return;
        }
        this.exception.printStackTrace();
        logger.info((Object)("Posting error report to SQL Power at URL <" + this.reportUrl + ">"));
        try {
            String line;
            HttpURLConnection dest = (HttpURLConnection)new URL(this.reportUrl).openConnection();
            dest.setConnectTimeout(3000);
            dest.setReadTimeout(3000);
            dest.setDoOutput(true);
            dest.setDoInput(true);
            dest.setUseCaches(false);
            dest.setRequestMethod("POST");
            dest.setRequestProperty("Content-Type", "text/xml");
            dest.connect();
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(dest.getOutputStream());
                ((OutputStream)out).write(this.toXML().getBytes("ISO-8859-1"));
                ((OutputStream)out).flush();
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            InputStreamReader inputStreamReader = new InputStreamReader(dest.getInputStream());
            BufferedReader in = new BufferedReader(inputStreamReader);
            StringBuffer response = new StringBuffer();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            in.close();
            logger.info((Object)("Error report servlet response: " + response));
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't send exception report to <\"" + this.reportUrl + "\">"), (Throwable)e);
        }
        logger.debug((Object)"Finished posting report");
    }

    public void addAdditionalInfo(String name, String value) {
        this.additionalInfo.put(name, value);
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public static long getApplicationUptime() {
        return System.currentTimeMillis() - applicationStartupTime;
    }
}

