/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.IWorkingCopyManager;

public class PreferencesAccess {
    public static PreferencesAccess getOriginalPreferences() {
        return new PreferencesAccess();
    }

    public static PreferencesAccess getWorkingCopyPreferences(IWorkingCopyManager iWorkingCopyManager) {
        return new WorkingCopyPreferencesAccess(iWorkingCopyManager);
    }

    private PreferencesAccess() {
    }

    public IScopeContext getDefaultScope() {
        return new DefaultScope();
    }

    public IScopeContext getInstanceScope() {
        return new InstanceScope();
    }

    public IScopeContext getProjectScope(IProject iProject) {
        return new ProjectScope(iProject);
    }

    /* synthetic */ PreferencesAccess(PreferencesAccess preferencesAccess) {
        this();
    }

    private static class WorkingCopyPreferencesAccess
    extends PreferencesAccess {
        private final IWorkingCopyManager fWorkingCopyManager;

        WorkingCopyPreferencesAccess(IWorkingCopyManager iWorkingCopyManager) {
            super(null);
            this.fWorkingCopyManager = iWorkingCopyManager;
        }

        private final IScopeContext getWorkingCopyScopeContext(IScopeContext iScopeContext) {
            return new WorkingCopyScopeContext(this.fWorkingCopyManager, iScopeContext);
        }

        public IScopeContext getDefaultScope() {
            return this.getWorkingCopyScopeContext(super.getDefaultScope());
        }

        public IScopeContext getInstanceScope() {
            return this.getWorkingCopyScopeContext(super.getInstanceScope());
        }

        public IScopeContext getProjectScope(IProject iProject) {
            return this.getWorkingCopyScopeContext(super.getProjectScope(iProject));
        }
    }

    private static class WorkingCopyScopeContext
    implements IScopeContext {
        private final IWorkingCopyManager fWorkingCopyManager;
        private final IScopeContext fOriginal;

        public WorkingCopyScopeContext(IWorkingCopyManager iWorkingCopyManager, IScopeContext iScopeContext) {
            this.fWorkingCopyManager = iWorkingCopyManager;
            this.fOriginal = iScopeContext;
        }

        public String getName() {
            return this.fOriginal.getName();
        }

        public IEclipsePreferences getNode(String string) {
            return this.fWorkingCopyManager.getWorkingCopy(this.fOriginal.getNode(string));
        }

        public IPath getLocation() {
            return this.fOriginal.getLocation();
        }
    }
}

