/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.internal.impl.CompatibilityDescriptionGroupImpl;
import org.eclipse.jst.j2ee.common.internal.util.CommonUtil;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBRelation;
import org.eclipse.jst.j2ee.ejb.EJBRelationshipRole;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.Relationships;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionResource;

public class EJBJarImpl
extends CompatibilityDescriptionGroupImpl
implements EJBJar {
    protected static final String EJB_CLIENT_JAR_EDEFAULT = null;
    protected String ejbClientJar = EJB_CLIENT_JAR_EDEFAULT;
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected AssemblyDescriptor assemblyDescriptor = null;
    protected EList enterpriseBeans = null;
    protected Relationships relationshipList = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected EClass eStaticClass() {
        return EjbPackage.Literals.EJB_JAR;
    }

    public boolean containsContainerManagedBeans() {
        Iterator it = this.getEnterpriseBeans().iterator();
        while (it.hasNext()) {
            EnterpriseBean ejb = (EnterpriseBean)it.next();
            if (!ejb.isEntity() || !((Entity)ejb).isContainerManagedEntity()) continue;
            return true;
        }
        return false;
    }

    public boolean containsSecurityRole(String name) {
        AssemblyDescriptor ad = this.getAssemblyDescriptor();
        return ad != null && ad.getSecurityRoleNamed(name) != null;
    }

    public List getBeanManagedBeans() {
        EList allBeans = this.getEnterpriseBeans();
        int size = allBeans.size();
        ArrayList<EnterpriseBean> beans = new ArrayList<EnterpriseBean>(size);
        int i = 0;
        while (i < size) {
            EnterpriseBean ejb = (EnterpriseBean)allBeans.get(i);
            if (ejb.isBeanManagedEntity()) {
                beans.add(ejb);
            }
            ++i;
        }
        return beans;
    }

    public List getContainerManagedBeans() {
        ArrayList<EnterpriseBean> cmps = new ArrayList<EnterpriseBean>(this.getEnterpriseBeans().size());
        Iterator it = this.getEnterpriseBeans().iterator();
        while (it.hasNext()) {
            EnterpriseBean ejb = (EnterpriseBean)it.next();
            if (!ejb.isEntity() || !((Entity)ejb).isContainerManagedEntity()) continue;
            cmps.add(ejb);
        }
        return cmps;
    }

    public List getEJB11ContainerManagedBeans() {
        ArrayList<EnterpriseBean> cmps = new ArrayList<EnterpriseBean>(this.getEnterpriseBeans().size());
        Iterator it = this.getEnterpriseBeans().iterator();
        while (it.hasNext()) {
            EnterpriseBean ejb = (EnterpriseBean)it.next();
            if (!ejb.isEntity() || !((Entity)ejb).isContainerManagedEntity() || ejb.getVersionID() > 11) continue;
            cmps.add(ejb);
        }
        return cmps;
    }

    public List getEJB20ContainerManagedBeans() {
        ArrayList<EnterpriseBean> cmps = new ArrayList<EnterpriseBean>(this.getEnterpriseBeans().size());
        Iterator it = this.getEnterpriseBeans().iterator();
        while (it.hasNext()) {
            EnterpriseBean ejb = (EnterpriseBean)it.next();
            if (!ejb.isEntity() || !((Entity)ejb).isContainerManagedEntity() || ejb.getVersionID() < 20) continue;
            cmps.add(ejb);
        }
        return cmps;
    }

    public List getMessageDrivenBeans() {
        EList ejbs = this.getEnterpriseBeans();
        int size = ejbs.size();
        ArrayList<EnterpriseBean> mdbs = new ArrayList<EnterpriseBean>(size);
        int i = 0;
        while (i < size) {
            EnterpriseBean ejb = (EnterpriseBean)ejbs.get(i);
            if (ejb.isMessageDriven()) {
                mdbs.add(ejb);
            }
            ++i;
        }
        return mdbs;
    }

    public List getEjbRelations() {
        return this.getRelationshipList() == null ? null : this.getRelationshipList().getEjbRelations();
    }

    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ref) {
        String link = ref.getLink();
        if (link == null) {
            return null;
        }
        return this.getEnterpriseBeanNamed(link);
    }

    public EnterpriseBean getEnterpriseBeanNamed(String ejbName) {
        if (ejbName == null) {
            return null;
        }
        EList beans = this.getEnterpriseBeans();
        int i = 0;
        while (i < beans.size()) {
            EnterpriseBean bean = (EnterpriseBean)beans.get(i);
            if (ejbName.equals(bean.getName())) {
                return bean;
            }
            ++i;
        }
        return null;
    }

    public List getEnterpriseBeansWithReference(JavaClass aJavaClass) {
        EList beans = this.getEnterpriseBeans();
        ArrayList<EnterpriseBean> result = new ArrayList<EnterpriseBean>();
        EnterpriseBean bean = null;
        int i = 0;
        while (i < beans.size()) {
            bean = (EnterpriseBean)beans.get(i);
            if (bean.hasJavaReference(aJavaClass)) {
                result.add(bean);
            }
            ++i;
        }
        return result;
    }

    public EnterpriseBean getEnterpriseBeanWithReference(JavaClass aJavaClass) {
        EList beans = this.getEnterpriseBeans();
        EnterpriseBean bean = null;
        int i = 0;
        while (i < beans.size()) {
            bean = (EnterpriseBean)beans.get(i);
            if (bean.hasJavaReference(aJavaClass)) {
                return bean;
            }
            ++i;
        }
        return null;
    }

    public List getSessionBeans() {
        EList allBeans = this.getEnterpriseBeans();
        int size = allBeans.size();
        ArrayList<EnterpriseBean> beans = new ArrayList<EnterpriseBean>(size);
        int i = 0;
        while (i < size) {
            EnterpriseBean ejb = (EnterpriseBean)allBeans.get(i);
            if (ejb.isSession()) {
                beans.add(ejb);
            }
            ++i;
        }
        return beans;
    }

    public boolean isVersion1_1Descriptor() {
        CommonUtil.checkDDObjectForVersion(this);
        EJBResource ejbRes = (EJBResource)this.eResource();
        return ejbRes.isEJB1_1();
    }

    public boolean isVersion2_0Descriptor() {
        CommonUtil.checkDDObjectForVersion(this);
        EJBResource ejbRes = (EJBResource)this.eResource();
        return ejbRes.isEJB2_0();
    }

    public void renameSecurityRole(String existingRoleName, String newRoleName) {
        AssemblyDescriptor ad = this.getAssemblyDescriptor();
        if (ad != null) {
            ad.renameSecurityRole(existingRoleName, newRoleName);
        }
        EList ejbs = this.getEnterpriseBeans();
        int i = 0;
        while (i < ejbs.size()) {
            EnterpriseBean ejb = (EnterpriseBean)ejbs.get(i);
            ejb.reSyncSecurityRoleRef(existingRoleName, newRoleName);
            ++i;
        }
    }

    public void setDisplayName(String newDisplayName) {
        super.setDisplayName(newDisplayName);
    }

    public String getEjbClientJar() {
        return this.ejbClientJar;
    }

    public void setEjbClientJar(String newEjbClientJar) {
        String oldEjbClientJar = this.ejbClientJar;
        this.ejbClientJar = newEjbClientJar;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldEjbClientJar, (Object)this.ejbClientJar));
        }
    }

    public String getVersion() {
        return this.version;
    }

    public int getVersionID() throws IllegalStateException {
        J2EEVersionResource ejbRes = (J2EEVersionResource)this.eResource();
        if (ejbRes == null) {
            if (this.version == null) {
                throw new IllegalStateException();
            }
            if (this.version.equals("2.1")) {
                return 21;
            }
            if (this.version.equals("2.0")) {
                return 20;
            }
            if (this.version.equals("1.1")) {
                return 11;
            }
            if (this.version.equals("1.0")) {
                return 10;
            }
        }
        return ejbRes.getModuleVersionID();
    }

    public int getJ2EEVersionID() throws IllegalStateException {
        J2EEVersionResource res = (J2EEVersionResource)this.eResource();
        if (res == null) {
            throw new IllegalStateException("XMLResource is null");
        }
        return res.getJ2EEVersionID();
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldVersion, (Object)this.version));
        }
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        return this.assemblyDescriptor;
    }

    public NotificationChain basicSetAssemblyDescriptor(AssemblyDescriptor newAssemblyDescriptor, NotificationChain msgs) {
        AssemblyDescriptor oldAssemblyDescriptor = this.assemblyDescriptor;
        this.assemblyDescriptor = newAssemblyDescriptor;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldAssemblyDescriptor, (Object)newAssemblyDescriptor);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setAssemblyDescriptor(AssemblyDescriptor newAssemblyDescriptor) {
        if (newAssemblyDescriptor != this.assemblyDescriptor) {
            NotificationChain msgs = null;
            if (this.assemblyDescriptor != null) {
                InternalEObject internalEObject = (InternalEObject)this.assemblyDescriptor;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.ejb.AssemblyDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseRemove((InternalEObject)this, 2, (Class)clazz, msgs);
            }
            if (newAssemblyDescriptor != null) {
                InternalEObject internalEObject = (InternalEObject)newAssemblyDescriptor;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.ejb.AssemblyDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd((InternalEObject)this, 2, (Class)clazz, msgs);
            }
            if ((msgs = this.basicSetAssemblyDescriptor(newAssemblyDescriptor, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)newAssemblyDescriptor, (Object)newAssemblyDescriptor));
        }
    }

    public EList getEnterpriseBeans() {
        if (this.enterpriseBeans == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jst.j2ee.ejb.EnterpriseBean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.enterpriseBeans = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 10, 19);
        }
        return this.enterpriseBeans;
    }

    public Relationships getRelationshipList() {
        return this.relationshipList;
    }

    public NotificationChain basicSetRelationshipList(Relationships newRelationshipList, NotificationChain msgs) {
        Relationships oldRelationshipList = this.relationshipList;
        this.relationshipList = newRelationshipList;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldRelationshipList, (Object)newRelationshipList);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setRelationshipList(Relationships newRelationshipList) {
        if (newRelationshipList != this.relationshipList) {
            NotificationChain msgs = null;
            if (this.relationshipList != null) {
                InternalEObject internalEObject = (InternalEObject)this.relationshipList;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.jst.j2ee.ejb.Relationships");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseRemove((InternalEObject)this, 1, (Class)clazz, msgs);
            }
            if (newRelationshipList != null) {
                InternalEObject internalEObject = (InternalEObject)newRelationshipList;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.jst.j2ee.ejb.Relationships");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd((InternalEObject)this, 1, (Class)clazz, msgs);
            }
            if ((msgs = this.basicSetRelationshipList(newRelationshipList, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newRelationshipList, (Object)newRelationshipList));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                if (this.assemblyDescriptor != null) {
                    msgs = ((InternalEObject)this.assemblyDescriptor).eInverseRemove((InternalEObject)this, -10, null, msgs);
                }
                return this.basicSetAssemblyDescriptor((AssemblyDescriptor)otherEnd, msgs);
            }
            case 10: {
                return ((InternalEList)this.getEnterpriseBeans()).basicAdd((Object)otherEnd, msgs);
            }
            case 11: {
                if (this.relationshipList != null) {
                    msgs = ((InternalEObject)this.relationshipList).eInverseRemove((InternalEObject)this, -12, null, msgs);
                }
                return this.basicSetRelationshipList((Relationships)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return this.basicSetAssemblyDescriptor(null, msgs);
            }
            case 10: {
                return ((InternalEList)this.getEnterpriseBeans()).basicRemove((Object)otherEnd, msgs);
            }
            case 11: {
                return this.basicSetRelationshipList(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getEjbClientJar();
            }
            case 8: {
                return this.getVersion();
            }
            case 9: {
                return this.getAssemblyDescriptor();
            }
            case 10: {
                return this.getEnterpriseBeans();
            }
            case 11: {
                return this.getRelationshipList();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setEjbClientJar((String)newValue);
                return;
            }
            case 8: {
                this.setVersion((String)newValue);
                return;
            }
            case 9: {
                this.setAssemblyDescriptor((AssemblyDescriptor)newValue);
                return;
            }
            case 10: {
                this.getEnterpriseBeans().clear();
                this.getEnterpriseBeans().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setRelationshipList((Relationships)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setEjbClientJar(EJB_CLIENT_JAR_EDEFAULT);
                return;
            }
            case 8: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 9: {
                this.setAssemblyDescriptor(null);
                return;
            }
            case 10: {
                this.getEnterpriseBeans().clear();
                return;
            }
            case 11: {
                this.setRelationshipList(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return EJB_CLIENT_JAR_EDEFAULT == null ? this.ejbClientJar != null : !EJB_CLIENT_JAR_EDEFAULT.equals(this.ejbClientJar);
            }
            case 8: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 9: {
                return this.assemblyDescriptor != null;
            }
            case 10: {
                return this.enterpriseBeans != null && !this.enterpriseBeans.isEmpty();
            }
            case 11: {
                return this.relationshipList != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (ejbClientJar: ");
        result.append(this.ejbClientJar);
        result.append(", version: ");
        result.append(this.version);
        result.append(')');
        return result.toString();
    }

    public EJBRelationshipRole getRelationshipRole(String aRoleName, ContainerManagedEntity sourceCMP) {
        if (aRoleName == null || sourceCMP == null) {
            return null;
        }
        EJBRelationshipRole role = null;
        if (this.getRelationshipList() != null) {
            EList relations = this.getRelationshipList().getEjbRelations();
            int size = relations.size();
            EJBRelation rel = null;
            int i = 0;
            while (i < size) {
                rel = (EJBRelation)relations.get(i);
                role = rel.getRelationshipRole(aRoleName);
                if (role != null && role.getSourceEntity() == sourceCMP) {
                    return role;
                }
                ++i;
            }
        }
        return null;
    }

    public EJBRelation getEJBRelation(String aRelationName) {
        Relationships relList = this.getRelationshipList();
        if (relList != null) {
            EList rels = relList.getEjbRelations();
            int size = rels.size();
            EJBRelation rel = null;
            int i = 0;
            while (i < size) {
                rel = (EJBRelation)rels.get(i);
                if (rel != null && aRelationName.equals(rel.getName())) {
                    return rel;
                }
                ++i;
            }
        }
        return null;
    }

    public List getEJBRelationsForSource(ContainerManagedEntity cmp) {
        Relationships relList = this.getRelationshipList();
        ArrayList<EJBRelation> result = null;
        if (relList != null) {
            EList rels = relList.getEjbRelations();
            int size = rels.size();
            EJBRelation rel = null;
            int i = 0;
            while (i < size) {
                rel = (EJBRelation)rels.get(i);
                if (rel != null) {
                    EList roles = rel.getRelationshipRoles();
                    int j = 0;
                    while (j < roles.size()) {
                        EJBRelationshipRole role = (EJBRelationshipRole)roles.get(j);
                        if (role.getSourceEntity() == cmp) {
                            if (result == null) {
                                result = new ArrayList<EJBRelation>();
                            }
                            result.add(rel);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public List getEJBRelationshipRolesForType(ContainerManagedEntity cmp) {
        Relationships relList = this.getRelationshipList();
        ArrayList<EJBRelationshipRole> result = null;
        if (relList != null) {
            EList rels = relList.getEjbRelations();
            int size = rels.size();
            EJBRelation rel = null;
            int i = 0;
            while (i < size) {
                rel = (EJBRelation)rels.get(i);
                if (rel != null) {
                    EList roles = rel.getRelationshipRoles();
                    int j = 0;
                    while (j < roles.size()) {
                        EJBRelationshipRole role = (EJBRelationshipRole)roles.get(j);
                        if (cmp.equals(role.getTypeEntity())) {
                            if (result == null) {
                                result = new ArrayList<EJBRelationshipRole>();
                            }
                            result.add(role);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }
}

