/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.net.URL;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.AbstractWebBrowser;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.DefaultBrowserSupport;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public class ExternalBrowserInstance
extends AbstractWebBrowser {
    protected IBrowserDescriptor browser;
    protected Process process;

    public ExternalBrowserInstance(String id, IBrowserDescriptor browser) {
        super(id);
        this.browser = browser;
    }

    public void openURL(URL url) throws PartInitException {
        String urlText = null;
        if (url != null) {
            urlText = url.toExternalForm();
        }
        if (urlText != null && !WebBrowserUtil.isWindows()) {
            int index = urlText.indexOf(" ");
            while (index >= 0) {
                urlText = String.valueOf(urlText.substring(0, index)) + "%20" + urlText.substring(index + 1);
                index = urlText.indexOf(" ");
            }
        }
        String location = this.browser.getLocation();
        String parameters = this.browser.getParameters();
        Trace.trace(Trace.FINEST, "Launching external Web browser: " + location + " - " + parameters + " - " + urlText);
        String params = parameters;
        if (params == null) {
            params = "";
        }
        if (urlText != null) {
            int urlIndex = params.indexOf("%URL%");
            if (urlIndex >= 0) {
                params = String.valueOf(params.substring(0, urlIndex)) + " " + urlText + " " + params.substring(urlIndex + "%URL%".length());
            } else {
                if (!params.endsWith(" ")) {
                    params = String.valueOf(params) + " ";
                }
                params = String.valueOf(params) + urlText;
            }
        }
        try {
            Trace.trace(Trace.FINEST, "Launching " + location + " " + params);
            this.process = params == null || params.length() == 0 ? Runtime.getRuntime().exec(location) : Runtime.getRuntime().exec(String.valueOf(location) + " " + params);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not launch external browser", e);
            WebBrowserUtil.openError(NLS.bind((String)Messages.errorCouldNotLaunchWebBrowser, (Object)urlText));
        }
        Thread thread = new Thread(){

            public void run() {
                try {
                    ExternalBrowserInstance.this.process.waitFor();
                    DefaultBrowserSupport.getInstance().removeBrowser((IWebBrowser)ExternalBrowserInstance.this);
                }
                catch (Exception exception) {}
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public boolean close() {
        try {
            this.process.destroy();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

