/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.internal.xhtml.UAContentParser;
import org.eclipse.help.internal.xhtml.UATransformManager;
import org.eclipse.help.internal.xhtml.XHTMLContentDescriber;
import org.eclipse.help.internal.xhtml.XHTMLSupport;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class DynamicContentProducer
implements IHelpContentProducer {
    private IContentDescriber xhtmlDescriber;

    public InputStream getInputStream(String pluginID, String href, Locale locale) {
        if (this.isXHTML(pluginID, href, locale)) {
            String file = href;
            int qloc = href.indexOf(63);
            if (qloc != -1) {
                file = href.substring(0, qloc);
            }
            boolean filter = true;
            if (qloc != -1 && qloc < href.length() - 1) {
                String query = href.substring(qloc + 1);
                filter = query.indexOf("filter=false") == -1;
            }
            return DynamicContentProducer.openXHTMLFromPlugin(pluginID, file, locale.toString(), filter);
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private boolean isXHTML(String pluginID, String href, Locale locale) {
        block20: {
            InputStream in;
            block19: {
                block17: {
                    boolean bl;
                    block18: {
                        String file = href;
                        int qloc = href.indexOf(63);
                        if (qloc != -1) {
                            file = href.substring(0, qloc);
                        }
                        if (this.xhtmlDescriber == null) {
                            this.xhtmlDescriber = new XHTMLContentDescriber();
                        }
                        in = null;
                        in = DynamicContentProducer.openXHTMLFromPluginRaw(pluginID, file, locale.toString());
                        if (in == null) break block17;
                        boolean bl2 = bl = this.xhtmlDescriber.describe(in, null) == 2;
                        if (in == null) break block18;
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return bl;
                    {
                        catch (Exception e) {
                            HelpPlugin.logError("An error occured in DynamicContentProducer while trying to determine the content type", e);
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                break block20;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private static InputStream openXHTMLFromPlugin(String pluginID, String file, String locale, boolean filter) {
        InputStream inputStream = DynamicContentProducer.openXHTMLFromPluginRaw(pluginID, file, locale);
        if (inputStream != null) {
            UAContentParser parser = new UAContentParser(inputStream);
            Document dom = parser.getDocument();
            XHTMLSupport support = new XHTMLSupport(pluginID, file, dom, locale);
            dom = support.processDOM(filter);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return UATransformManager.getAsInputStream(dom);
        }
        return null;
    }

    private static InputStream openXHTMLFromPluginRaw(String pluginID, String file, String locale) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle != null) {
            InputStream inputStream = ResourceLocator.openFromZip(bundle, "doc.zip", file, locale);
            if (inputStream == null) {
                inputStream = ResourceLocator.openFromPlugin(bundle, file, locale);
            }
            return inputStream;
        }
        return null;
    }
}

