/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;

public class JavaFileLinkHelper
implements ILinkHelper {
    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        IEditorPart part = EditorUtility.isOpenInEditor(element);
        if (part != null) {
            page.bringToTop((IWorkbenchPart)part);
            if (element instanceof IJavaElement) {
                EditorUtility.revealInEditor(part, (IJavaElement)element);
            }
        }
    }

    public IStructuredSelection findSelection(IEditorInput input) {
        IClassFile javaElement = null;
        if (input instanceof IClassFileEditorInput) {
            javaElement = ((IClassFileEditorInput)input).getClassFile();
        } else if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            javaElement = JavaCore.create((IFile)file);
        } else if (input instanceof JarEntryEditorInput) {
            javaElement = ((JarEntryEditorInput)input).getStorage();
        }
        return javaElement != null ? new StructuredSelection((Object)javaElement) : StructuredSelection.EMPTY;
    }
}

