/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class VisibilityControlUtil {
    private VisibilityControlUtil() {
    }

    public static Composite createVisibilityControl(Composite parent, final IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
        List allowedVisibilities = VisibilityControlUtil.convertToIntegerList(availableVisibilities);
        if (allowedVisibilities.size() == 1) {
            return null;
        }
        Group group = new Group(parent, 0);
        group.setText(RefactoringMessages.VisibilityControlUtil_Access_modifier);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        String[] labels = new String[]{"&public", "pro&tected", RefactoringMessages.VisibilityControlUtil_defa_ult_4, "pri&vate"};
        Integer[] data = new Integer[]{new Integer(1), new Integer(4), new Integer(0), new Integer(2)};
        Integer initialVisibility = new Integer(correctVisibility);
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button((Composite)group, 16);
            Integer visibilityCode = data[i];
            radio.setText(labels[i]);
            radio.setData((Object)visibilityCode);
            radio.setSelection(visibilityCode.equals(initialVisibility));
            radio.setEnabled(allowedVisibilities.contains(visibilityCode));
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    visibilityChangeListener.visibilityChanged((Integer)event.widget.getData());
                }
            });
            ++i;
        }
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    private static List convertToIntegerList(int[] array) {
        ArrayList<Integer> result = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            result.add(new Integer(array[i]));
            ++i;
        }
        return result;
    }
}

