/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.reflect.MethodSignatureParser;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class Constructor
extends AccessibleObject
implements Member,
GenericDeclaration {
    private static final int CONSTRUCTOR_MODIFIERS = 7;
    private Class declaringClass;
    private Class[] exception_types;
    private Class[] parameter_types;
    private int offset;

    private Constructor() {
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.declaringClass.getName();
    }

    private native int getModifiersInternal();

    public int getModifiers() {
        return this.getModifiersInternal() & 7;
    }

    public boolean isSynthetic() {
        return (this.getModifiersInternal() & 0x1000) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiersInternal() & 0x80) != 0;
    }

    public Class[] getParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return (Class[])this.parameter_types.clone();
    }

    public Class[] getExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return (Class[])this.exception_types.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Constructor)) {
            return false;
        }
        Constructor constructor = (Constructor)object;
        return this.declaringClass == constructor.declaringClass && this.offset == constructor.offset;
    }

    public int hashCode() {
        return this.declaringClass.getName().hashCode();
    }

    public String toString() {
        if (this.parameter_types == null) {
            this.getType();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (n != 0) {
            Modifier.toString(n, stringBuffer);
            stringBuffer.append(" ");
        }
        Method.appendClassName(stringBuffer, this.declaringClass);
        stringBuffer.append("(");
        for (int i = 0; i < this.parameter_types.length; ++i) {
            Method.appendClassName(stringBuffer, this.parameter_types[i]);
            if (i >= this.parameter_types.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static void addTypeParameters(StringBuilder stringBuilder, TypeVariable[] typeVariableArray) {
        if (typeVariableArray.length == 0) {
            return;
        }
        stringBuilder.append('<');
        for (int i = 0; i < typeVariableArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(typeVariableArray[i]);
        }
        stringBuilder.append("> ");
    }

    public String toGenericString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(128);
        Modifier.toString(this.getModifiers(), stringBuilder).append(' ');
        Constructor.addTypeParameters(stringBuilder, this.getTypeParameters());
        stringBuilder.append(this.getDeclaringClass().getName()).append('(');
        Type[] typeArray = this.getGenericParameterTypes();
        if (typeArray.length > 0) {
            stringBuilder.append(typeArray[0]);
            for (n = 1; n < typeArray.length; ++n) {
                stringBuilder.append(',').append(typeArray[n]);
            }
        }
        stringBuilder.append(')');
        typeArray = this.getGenericExceptionTypes();
        if (typeArray.length > 0) {
            stringBuilder.append(" throws ").append(typeArray[0]);
            for (n = 1; n < typeArray.length; ++n) {
                stringBuilder.append(',').append(typeArray[n]);
            }
        }
        return stringBuilder.toString();
    }

    public native Object newInstance(Object[] var1) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public TypeVariable[] getTypeParameters() {
        String string = this.getSignature();
        if (string == null) {
            return new TypeVariable[0];
        }
        MethodSignatureParser methodSignatureParser = new MethodSignatureParser(this, string);
        return methodSignatureParser.getTypeParameters();
    }

    private String getSignature() {
        return null;
    }

    public Type[] getGenericExceptionTypes() {
        String string = this.getSignature();
        if (string == null) {
            return this.getExceptionTypes();
        }
        MethodSignatureParser methodSignatureParser = new MethodSignatureParser(this, string);
        return methodSignatureParser.getGenericExceptionTypes();
    }

    public Type[] getGenericParameterTypes() {
        String string = this.getSignature();
        if (string == null) {
            return this.getParameterTypes();
        }
        MethodSignatureParser methodSignatureParser = new MethodSignatureParser(this, string);
        return methodSignatureParser.getGenericParameterTypes();
    }

    private native void getType();
}

