#!/bin/sh
echo 'name: ListLike
version: 1.0.1
id: ListLike-1.0.1-24733b29426ef902776a2ed67e62da90

license: LGPL
copyright: Copyright (c) 2007-2008 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://software.complete.org/listlike
package-url:
description: Generic support for list-like structures in Haskell.
             .
             The ListLike module provides a common interface to the various Haskell
             types that are list-like.  Predefined interfaces include standard
             Haskell lists, Arrays, ByteStrings, and lazy ByteStrings.  Custom
             types can easily be made ListLike instances as well.
             .
             ListLike also provides for String-like types, such as String and
             ByteString, for types that support input and output, and for types that can handle
             infinite lists.
category: Generics
author: John Goerzen
pkgpath: devel/hs-ListLike
exposed: True
exposed-modules: Data.ListLike Data.ListLike.Base
                 Data.ListLike.FoldableLL Data.ListLike.IO Data.ListLike.Instances
                 Data.ListLike.String Data.ListLike.Utils
hidden-modules:
import-dirs: /usr/local/lib/ghc/ListLike-1.0.1
library-dirs: /usr/local/lib/ghc/ListLike-1.0.1
hs-libraries: HSListLike-1.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.2-ecfce597e0f16c4cd1df0e1d22fd66d4
         base-4.3.1.0-912d55d387093f740e3bcd2ffbf1dd83
         bytestring-0.9.1.10-e7cebdd905566e960c42140389871ec1
         containers-0.4.0.0-18deac99a132f04751d862b77aab136e
         haskell98-1.1.0.1-37bbd494afca009c19843e11b5432f37
         mtl-2.0.1.0-9763a8821c812a910d327bad2c0d23b2
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-ListLike-1.0.1/html/ListLike.haddock
haddock-html: /usr/local/share/doc/hs-ListLike-1.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
