#!/bin/sh
echo 'name: atom
version: 1.0.9
id: atom-1.0.9-be63d376c3af520b6424fb2bd9b1dee3

license: BSD3
copyright:
maintainer: Tom Hawkins <tomahawkins@gmail.com>, Lee Pike <leepike@gmail.com>
stability:
homepage: http://tomahawkins.org
package-url:
description: Atom is a Haskell DSL for designing hard realtime embedded software.
             Based on guarded atomic actions (similar to STM), Atom enables
             highly concurrent programming without the need for mutex locking.
             In addition, Atom performs compile-time task scheduling and generates code
             with deterministic execution time and constant memory use, simplifying the
             process of timing verification and memory consumption in hard realtime applications.
             Without mutex locking and run-time task scheduling, Atom eliminates
             the need and overhead of RTOSs for many embedded applications.
category: Language, Embedded
author: Tom Hawkins <tomahawkins@gmail.com>
pkgpath: devel/hs-atom
exposed: True
exposed-modules: Language.Atom Language.Atom.Analysis
                 Language.Atom.Code Language.Atom.Common Language.Atom.Compile
                 Language.Atom.Elaboration Language.Atom.Example
                 Language.Atom.Expressions Language.Atom.Language
                 Language.Atom.Scheduling Language.Atom.Unit Language.Atom.UeMap
hidden-modules:
import-dirs: /usr/local/lib/ghc/atom-1.0.9
library-dirs: /usr/local/lib/ghc/atom-1.0.9
hs-libraries: HSatom-1.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-912d55d387093f740e3bcd2ffbf1dd83
         bimap-0.2.4-af8fdf7f484a9a616c0bebcb119f0781
         containers-0.4.0.0-18deac99a132f04751d862b77aab136e
         mtl-2.0.1.0-9763a8821c812a910d327bad2c0d23b2
         process-1.0.1.5-4cab1bf0666275ac101dd48c7565b64c
         syb-0.3-8db7bc4339a1cb8a6f2a46c40447ef0b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-atom-1.0.9/html/atom.haddock
haddock-html: /usr/local/share/doc/hs-atom-1.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
