#!/bin/sh
echo 'name: crypto-api
version: 0.6.1
id: crypto-api-0.6.1-66a96a480344b527cd3ec6d9cc827075

license: BSD3
copyright: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike) (see AUTHORS)
maintainer: Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability: stable
homepage: http://trac.haskell.org/crypto-api/wiki
package-url:
description: A generic interface for cryptographic operations,
             platform independent quality RNG, property tests
             and known-answer tests (KATs) for common algorithms,
             and a basic benchmark infrastructure.
             Maintainers of hash and cipher implementations are
             encouraged to add instances for the classes defined
             in Crypto.Classes.  Crypto users are similarly
             encouraged to use the interfaces defined in the Classes
             module.
             Any concepts or functions of general use to more than
             one cryptographic algorithm (ex: padding) is within
             scope of this package.
category: Data, Cryptography
author: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)
pkgpath: security/hs-crypto-api
exposed: True
exposed-modules: Crypto.Classes Crypto.Types Crypto.HMAC
                 Crypto.Modes System.Crypto.Random Crypto.Random Crypto.Padding
hidden-modules: Crypto.Util Crypto.CPoly
import-dirs: /usr/local/lib/ghc/crypto-api-0.6.1
library-dirs: /usr/local/lib/ghc/crypto-api-0.6.1
hs-libraries: HScrypto-api-0.6.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-912d55d387093f740e3bcd2ffbf1dd83
         bytestring-0.9.1.10-e7cebdd905566e960c42140389871ec1
         cereal-0.3.0.0-3cb8b258e48ebb16acfcc9dfed280198
         largeword-1.0.0-132fd8705653043b8d913187cdc25841
         tagged-0.2-b0871a68a3ca203a7cd9949ee1a64545
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-crypto-api-0.6.1/html/crypto-api.haddock
haddock-html: /usr/local/share/doc/hs-crypto-api-0.6.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
