#!/bin/sh
echo 'name: hashed-storage
version: 0.5.4
id: hashed-storage-0.5.4-0c026aabb96c43b44eff9652544508f9

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.4
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.4
hs-libraries: HShashed-storage-0.5.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-912d55d387093f740e3bcd2ffbf1dd83
         binary-0.5.0.2-721115387273250b168393e8301b841f
         bytestring-0.9.1.10-e7cebdd905566e960c42140389871ec1
         containers-0.4.0.0-18deac99a132f04751d862b77aab136e
         dataenc-0.13.0.4-b2f5ca0bf48d97148469dd08e88a4864
         directory-1.1.0.0-9b4fc50fd8f1413dca2a5e01dd665f6d
         extensible-exceptions-0.1.1.2-d8c5b906654260efd7249f497d17a831
         filepath-1.2.0.0-679ac50c41ba31bfc69abf444d9852e4
         mmap-0.5.6-16333111c2533d9f4c1c95a5f45f334e
         mtl-2.0.1.0-9763a8821c812a910d327bad2c0d23b2
         zlib-0.5.3.1-5fbdf714525b76e0e601c2ffb25f2044
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.4/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
