/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class CreateFieldFromUsageFix
extends CreateFieldFix {
    private final GrReferenceExpression myRefExpression;

    public CreateFieldFromUsageFix(GrReferenceExpression refExpression, GrMemberOwner targetClass) {
        super(targetClass);
        this.myRefExpression = refExpression;
    }

    @Override
    @Nullable
    protected String getFieldName() {
        return this.myRefExpression.getReferenceName();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.from.usage.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromUsageFix.getFamilyName must not return null");
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateFieldFromUsageFix.isAvailable must not be null");
        }
        return super.isAvailable(project, editor, file) && this.myRefExpression.isValid();
    }

    @Override
    protected String[] generateModifiers() {
        if (this.myRefExpression != null && PsiUtil.isInStaticContext(this.myRefExpression, this.getTargetClass())) {
            return new String[]{"static"};
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    protected TypeConstraint[] calculateTypeConstrains() {
        return GroovyExpectedTypesProvider.calculateTypeConstraints(this.myRefExpression);
    }
}

