/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.unscramble.UnscrambleDialog;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexedRootsProvider;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import groovy.lang.Closure;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.event.HyperlinkEvent;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.CustomMembersGenerator;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslExecutor;
import org.jetbrains.plugins.groovy.dsl.GroovyDslIndexedRootProvider;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.toplevel.ClassContextFilter;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovyDslFileIndex
extends ScalarIndexExtension<String> {
    public static final Key<CachedValue<ConcurrentFactoryMap<GroovyClassDescriptor, CustomMembersHolder>>> CACHED_ENHANCEMENTS = Key.create((String)"CACHED_ENHANCEMENTS");
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex");
    private static final FileAttribute ENABLED = new FileAttribute("ENABLED", 0);
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"GroovyDslFileIndex");
    @NonNls
    private static final String OUR_KEY = "ourKey";
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();
    private final MyInputFilter myInputFilter = new MyInputFilter();
    private static final Map<String, Pair<GroovyDslExecutor, Long>> ourMapping = new ConcurrentHashMap();
    private static final MultiMap<String, LinkedBlockingQueue<Pair<GroovyFile, GroovyDslExecutor>>> filesInProcessing = new ConcurrentMultiMap();
    private final EnumeratorStringDescriptor myKeyDescriptor = new EnumeratorStringDescriptor();
    private static final byte[] ENABLED_FLAG = new byte[]{-17};
    private static IndexedRootsProvider[] gdslRootsProviders;
    private static final UserDataCache<CachedValue<List<GroovyFile>>, Project, Object> DSL_FILES_CACHE;

    public ID<String, Void> getName() {
        return NAME;
    }

    public DataIndexer<String, Void, FileContent> getIndexer() {
        return this.myDataIndexer;
    }

    public KeyDescriptor<String> getKeyDescriptor() {
        return this.myKeyDescriptor;
    }

    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }

    public boolean dependsOnFileContent() {
        return false;
    }

    public int getVersion() {
        return 0;
    }

    public static boolean isActivated(VirtualFile file) {
        try {
            byte[] bytes = ENABLED.readAttributeBytes(file);
            if (bytes == null) {
                return true;
            }
            return bytes.length == ENABLED_FLAG.length && bytes[0] == ENABLED_FLAG[0];
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void activateUntilModification(final VirtualFile vfile) {
        final Document document = FileDocumentManager.getInstance().getDocument(vfile);
        if (document != null) {
            document.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void beforeDocumentChange(DocumentEvent e) {
                    GroovyDslFileIndex.disableFile(vfile);
                    document.removeDocumentListener((DocumentListener)this);
                }
            });
        }
        try {
            ENABLED.writeAttributeBytes(vfile, ENABLED_FLAG);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void disableFile(VirtualFile vfile) {
        try {
            ENABLED.writeAttributeBytes(vfile, new byte[0]);
        }
        catch (IOException e1) {
            LOG.error((Throwable)e1);
        }
        ourMapping.remove(vfile.getUrl());
    }

    @Nullable
    private static GroovyDslExecutor getCachedExecutor(@NotNull VirtualFile file, long stamp) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex.getCachedExecutor must not be null");
        }
        Pair<GroovyDslExecutor, Long> pair = ourMapping.get(file.getUrl());
        if (pair == null || (Long)pair.second != stamp) {
            return null;
        }
        return (GroovyDslExecutor)pair.first;
    }

    public static boolean processExecutors(PsiClass psiClass, PsiElement place, PsiScopeProcessor processor) {
        if (!(place instanceof GrReferenceExpression) || PsiTreeUtil.getParentOfType((PsiElement)place, PsiAnnotation.class) != null) {
            return true;
        }
        LinkedBlockingQueue<Pair<GroovyFile, GroovyDslExecutor>> queue = new LinkedBlockingQueue<Pair<GroovyFile, GroovyDslExecutor>>();
        int count = GroovyDslFileIndex.queueExecutors(psiClass.getProject(), queue);
        GroovyClassDescriptor descriptor = new GroovyClassDescriptor(psiClass, place);
        try {
            while (count > 0) {
                ProgressManager.checkCanceled();
                Pair<GroovyFile, GroovyDslExecutor> pair = queue.poll(20L, TimeUnit.MILLISECONDS);
                if (pair == null) continue;
                GroovyDslExecutor executor = (GroovyDslExecutor)pair.second;
                GroovyFile dslFile = (GroovyFile)pair.first;
                if (executor != null && !GroovyDslFileIndex.processExecutor(executor, descriptor, processor, dslFile)) {
                    return false;
                }
                --count;
            }
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private static int queueExecutors(Project project, LinkedBlockingQueue<Pair<GroovyFile, GroovyDslExecutor>> queue) {
        int count = 0;
        for (GroovyFile file : (List)((CachedValue)DSL_FILES_CACHE.get((UserDataHolder)project, null)).getValue()) {
            long stamp = file.getModificationStamp();
            VirtualFile vfile = file.getVirtualFile();
            assert (vfile != null);
            GroovyDslExecutor cached = GroovyDslFileIndex.getCachedExecutor(vfile, stamp);
            ++count;
            if (cached == null) {
                file.putUserData(CACHED_ENHANCEMENTS, null);
                GroovyDslFileIndex.scheduleParsing(queue, file, vfile, stamp, file.getText());
                continue;
            }
            queue.offer((Pair<GroovyFile, GroovyDslExecutor>)Pair.create((Object)file, (Object)cached));
        }
        return count;
    }

    private static boolean processExecutor(final GroovyDslExecutor executor, GroovyClassDescriptor descriptor, PsiScopeProcessor processor, final GroovyFile dslFile) {
        final Project project = dslFile.getProject();
        ConcurrentFactoryMap map = (ConcurrentFactoryMap)CachedValuesManager.getManager((Project)dslFile.getProject()).getCachedValue((UserDataHolder)dslFile, CACHED_ENHANCEMENTS, (CachedValueProvider)new CachedValueProvider<ConcurrentFactoryMap<GroovyClassDescriptor, CustomMembersHolder>>(){

            public CachedValueProvider.Result<ConcurrentFactoryMap<GroovyClassDescriptor, CustomMembersHolder>> compute() {
                ConcurrentFactoryMap<GroovyClassDescriptor, CustomMembersHolder> result = new ConcurrentFactoryMap<GroovyClassDescriptor, CustomMembersHolder>(){

                    protected CustomMembersHolder create(GroovyClassDescriptor key) {
                        PsiElement place = key.getPlace();
                        String fqn = key.getQualifiedName();
                        ProcessingContext ctx = new ProcessingContext();
                        ctx.put(ClassContextFilter.getClassKey(fqn), (Object)key.getPsiClass());
                        try {
                            if (!this.isApplicable(place, fqn, ctx)) {
                                return null;
                            }
                            CustomMembersGenerator generator = new CustomMembersGenerator(project, place, fqn);
                            executor.processVariants(key, generator, place, fqn, ctx);
                            return generator.getMembersHolder();
                        }
                        catch (InvokerInvocationException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof ProcessCanceledException) {
                                throw (ProcessCanceledException)cause;
                            }
                            if (cause instanceof OutOfMemoryError) {
                                throw (OutOfMemoryError)cause;
                            }
                            GroovyDslFileIndex.handleDslError(e, project, dslFile);
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (OutOfMemoryError e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            GroovyDslFileIndex.handleDslError(e, project, dslFile);
                        }
                        return null;
                    }

                    private boolean isApplicable(PsiElement place, String fqn, ProcessingContext ctx) {
                        for (Pair<ContextFilter, Closure> pair : executor.getEnhancers()) {
                            if (!((ContextFilter)pair.first).isApplicable(place, fqn, ctx)) continue;
                            return true;
                        }
                        return false;
                    }
                };
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, dslFile});
            }
        }, false);
        assert (map != null);
        CustomMembersHolder holder = (CustomMembersHolder)map.get((Object)descriptor);
        return holder == null || holder.processMembers(processor);
    }

    private static boolean handleDslError(Throwable e, Project project, GroovyFile dslFile) {
        if (project.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(e);
            return true;
        }
        GroovyDslFileIndex.invokeDslErrorPopup(e, project, dslFile.getVirtualFile());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleParsing(LinkedBlockingQueue<Pair<GroovyFile, GroovyDslExecutor>> queue, final GroovyFile file, final VirtualFile vfile, final long stamp, final String text) {
        final Project project = file.getProject();
        final String fileUrl = vfile.getUrl();
        Runnable parseScript = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GroovyDslExecutor executor = GroovyDslFileIndex.getCachedExecutor(vfile, stamp);
                if (executor == null) {
                    executor = GroovyDslFileIndex.createExecutor(text, vfile, project);
                    ourMapping.put(vfile.getUrl(), Pair.create((Object)executor, (Object)stamp));
                    if (executor != null) {
                        GroovyDslFileIndex.activateUntilModification(vfile);
                    }
                }
                VirtualFile virtualFile = vfile;
                synchronized (virtualFile) {
                    Collection queuesForFile = filesInProcessing.remove((Object)fileUrl);
                    for (LinkedBlockingQueue queue : queuesForFile) {
                        queue.offer(Pair.create((Object)file, (Object)executor));
                    }
                }
            }
        };
        VirtualFile virtualFile = vfile;
        synchronized (virtualFile) {
            boolean isNewRequest = !filesInProcessing.containsKey((Object)fileUrl);
            filesInProcessing.putValue((Object)fileUrl, queue);
            if (isNewRequest) {
                ApplicationManager.getApplication().executeOnPooledThread(parseScript);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static GroovyDslExecutor createExecutor(String text, VirtualFile vfile, Project project) {
        try {
            return new GroovyDslExecutor(text, vfile.getName());
        }
        catch (Throwable e) {
            if (project.isDisposed()) {
                LOG.error(e);
                return null;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    LOG.error(e);
                }
                finally {
                    return null;
                }
            }
            GroovyDslFileIndex.invokeDslErrorPopup(e, project, vfile);
            return null;
        }
    }

    private static void invokeDslErrorPopup(Throwable e, final Project project, VirtualFile vfile) {
        if (!GroovyDslFileIndex.isActivated(vfile)) {
            return;
        }
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        final String exceptionText = writer.toString();
        LOG.info(exceptionText);
        ((Notifications)ApplicationManager.getApplication().getMessageBus().syncPublisher(Notifications.TOPIC)).notify(new Notification("Groovy DSL parsing", "DSL script execution error", "<p>" + e.getMessage() + "</p><p><a href=\"\">Click here to investigate.</a></p>", NotificationType.ERROR, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex$5.hyperlinkUpdate must not be null");
                }
                if (event == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex$5.hyperlinkUpdate must not be null");
                }
                UnscrambleDialog dialog = new UnscrambleDialog(project);
                dialog.setText(exceptionText);
                dialog.show();
                notification.expire();
            }
        }));
        GroovyDslFileIndex.disableFile(vfile);
    }

    static /* synthetic */ IndexedRootsProvider[] access$302(IndexedRootsProvider[] x0) {
        gdslRootsProviders = x0;
        return x0;
    }

    static {
        DSL_FILES_CACHE = new UserDataCache<CachedValue<List<GroovyFile>>, Project, Object>("DSL_FILES_CACHE"){

            protected CachedValue<List<GroovyFile>> compute(final Project project, Object p) {
                return CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<List<GroovyFile>>(){

                    public CachedValueProvider.Result<List<GroovyFile>> compute() {
                        if (gdslRootsProviders == null) {
                            GroovyDslFileIndex.access$302((IndexedRootsProvider[])ContainerUtil.findAllAsArray((Object[])IndexedRootsProvider.EP_NAME.getExtensions(), GroovyDslIndexedRootProvider.class));
                        }
                        AdditionalIndexableFileSet standardSet = new AdditionalIndexableFileSet(gdslRootsProviders);
                        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                        AdditionalIndexedRootsScope scope = new AdditionalIndexedRootsScope(GlobalSearchScope.allScope((Project)project), (IndexableFileSet)standardSet);
                        ArrayList<GroovyFile> result = new ArrayList<GroovyFile>();
                        for (VirtualFile vfile : FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)GroovyDslFileIndex.OUR_KEY, (GlobalSearchScope)scope)) {
                            PsiFile psiFile;
                            if (!vfile.isValid() || !standardSet.isInSet(vfile) && !fileIndex.isInLibraryClasses(vfile) && !fileIndex.isInLibrarySource(vfile) && (!fileIndex.isInSourceContent(vfile) || !GroovyDslFileIndex.isActivated(vfile)) || !((psiFile = PsiManager.getInstance((Project)project).findFile(vfile)) instanceof GroovyFile)) continue;
                            GroovyFile file = (GroovyFile)psiFile;
                            result.add(file);
                        }
                        return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
                    }
                }, false);
            }
        };
    }

    private static class MyInputFilter
    implements FileBasedIndex.InputFilter {
        private MyInputFilter() {
        }

        public boolean acceptInput(VirtualFile file) {
            return "gdsl".equals(file.getExtension());
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(FileContent inputData) {
            Map<String, Object> map = Collections.singletonMap(GroovyDslFileIndex.OUR_KEY, null);
            if (map == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/dsl/GroovyDslFileIndex$MyDataIndexer.map must not return null");
            }
            return map;
        }
    }
}

