/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.StrictContextExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class SwitchStatement
implements GroovyElementTypes {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, kSWITCH);
        if (!ParserUtils.getToken(builder, mLPAREN, GroovyBundle.message("lparen.expected", new Object[0]))) {
            marker.done((IElementType)SWITCH_STATEMENT);
            return true;
        }
        if (!StrictContextExpression.parse(builder, parser)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        ParserUtils.getToken(builder, mNLS);
        if (!ParserUtils.getToken(builder, mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]))) {
            while (!(builder.eof() || mNLS.equals(builder.getTokenType()) || mRPAREN.equals(builder.getTokenType()))) {
                builder.error(GroovyBundle.message("rparen.expected", new Object[0]));
                builder.advanceLexer();
            }
            if (!ParserUtils.getToken(builder, mRPAREN)) {
                marker.done((IElementType)SWITCH_STATEMENT);
                return true;
            }
        }
        PsiBuilder.Marker warn = builder.mark();
        ParserUtils.getToken(builder, mNLS);
        if (!mLCURLY.equals(builder.getTokenType())) {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("case.block.expected", new Object[0]));
            marker.done((IElementType)SWITCH_STATEMENT);
            return true;
        }
        warn.drop();
        SwitchStatement.parseCaseBlock(builder, parser);
        marker.done((IElementType)SWITCH_STATEMENT);
        return true;
    }

    private static void parseCaseBlock(PsiBuilder builder, GroovyParser parser) {
        ParserUtils.getToken(builder, mLCURLY);
        ParserUtils.getToken(builder, mNLS);
        if (ParserUtils.getToken(builder, mRCURLY)) {
            return;
        }
        if (!kCASE.equals(builder.getTokenType()) && !kDEFAULT.equals(builder.getTokenType())) {
            builder.error(GroovyBundle.message("case.expected", new Object[0]));
            while (!(builder.eof() || kCASE.equals(builder.getTokenType()) || kDEFAULT.equals(builder.getTokenType()) || mRCURLY.equals(builder.getTokenType()))) {
                builder.error(GroovyBundle.message("case.expected", new Object[0]));
                builder.advanceLexer();
            }
        }
        while (kCASE.equals(builder.getTokenType()) || kDEFAULT.equals(builder.getTokenType())) {
            PsiBuilder.Marker sectionMarker = builder.mark();
            SwitchStatement.parseCaseLabel(builder, parser);
            if (builder.getTokenType() == mRCURLY || ParserUtils.lookAhead(builder, mNLS, mRCURLY)) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            } else {
                parser.parseSwitchCaseList(builder);
            }
            sectionMarker.done((IElementType)CASE_SECTION);
        }
        ParserUtils.getToken(builder, mRCURLY, GroovyBundle.message("rcurly.expected", new Object[0]));
    }

    public static void parseCaseLabel(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker label = builder.mark();
        IElementType elem = builder.getTokenType();
        ParserUtils.getToken(builder, TokenSet.create((IElementType[])new IElementType[]{kCASE, kDEFAULT}));
        if (kCASE.equals(elem)) {
            AssignmentExpression.parse(builder, parser);
        }
        ParserUtils.getToken(builder, mCOLON, GroovyBundle.message("colon.expected", new Object[0]));
        label.done((IElementType)CASE_LABEL);
        ParserUtils.getToken(builder, mNLS);
        if (builder.getTokenType() == kCASE || builder.getTokenType() == kDEFAULT) {
            SwitchStatement.parseCaseLabel(builder, parser);
        }
    }
}

