/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;

class ReadWriteVariableInstructionImpl
extends InstructionImpl
implements ReadWriteVariableInstruction {
    private final boolean myIsWrite;
    public String myName;

    ReadWriteVariableInstructionImpl(String varName, PsiElement element, int num, boolean isWrite) {
        super(element, num);
        this.myName = varName;
        this.myIsWrite = isWrite;
    }

    ReadWriteVariableInstructionImpl(PsiVariable variable, int num) {
        super((PsiElement)variable, num);
        this.myName = variable.getName();
        this.myIsWrite = true;
    }

    ReadWriteVariableInstructionImpl(GrReferenceExpression refExpr, int num, boolean isWrite) {
        super(refExpr, num);
        this.myName = refExpr.getReferenceName();
        this.myIsWrite = isWrite;
    }

    @Override
    public String getVariableName() {
        return this.myName;
    }

    @Override
    public boolean isWrite() {
        return this.myIsWrite;
    }

    @Override
    protected String getElementPresentation() {
        return (this.isWrite() ? "WRITE " : "READ ") + this.myName;
    }
}

