/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;

public class GrConstructorInvocationImpl
extends GroovyPsiElementImpl
implements GrConstructorInvocation {
    private static final TokenSet THIS_OR_SUPER_SET = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.kTHIS, GroovyTokenTypes.kSUPER});

    public GrConstructorInvocationImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrConstructorInvocationImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitConstructorInvocation(this);
    }

    public String toString() {
        return "Constructor invocation";
    }

    @Override
    @NotNull
    public GrArgumentList getArgumentList() {
        GrArgumentList grArgumentList = (GrArgumentList)this.findChildByClass(GrArgumentList.class);
        if (grArgumentList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrConstructorInvocationImpl.getArgumentList must not return null");
        }
        return grArgumentList;
    }

    @Override
    @Nullable
    public GrExpression removeArgument(int number) {
        return this.getArgumentList().removeArgument(number);
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) throws IncorrectOperationException {
        return this.getArgumentList().addNamedArgument(namedArgument);
    }

    @Override
    public boolean isSuperCall() {
        return this.findChildByType(GroovyTokenTypes.kSUPER) != null;
    }

    @Override
    public boolean isThisCall() {
        return this.findChildByType(GroovyTokenTypes.kTHIS) != null;
    }

    @Override
    public PsiElement getThisOrSuperKeyword() {
        return this.findChildByType(THIS_OR_SUPER_SET);
    }

    @Override
    public GroovyResolveResult[] multiResolveConstructor() {
        PsiClass clazz = this.getDelegatedClass();
        if (clazz != null) {
            PsiSubstitutor substitutor;
            PsiType[] argTypes = PsiUtil.getArgumentTypes(this.getFirstChild(), false);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            if (this.isThisCall()) {
                substitutor = PsiSubstitutor.EMPTY;
            } else {
                GrTypeDefinition enclosing = this.getEnclosingClass();
                assert (enclosing != null);
                substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)clazz, (PsiClass)enclosing, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            }
            PsiClassType thisType = factory.createType(clazz, substitutor);
            MethodResolverProcessor processor = new MethodResolverProcessor(clazz.getName(), this, true, (PsiType)thisType, argTypes, PsiType.EMPTY_ARRAY);
            clazz.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor), null, (PsiElement)this);
            for (NonCodeMembersProcessor membersProcessor : (NonCodeMembersProcessor[])NonCodeMembersProcessor.EP_NAME.getExtensions()) {
                if (!membersProcessor.processNonCodeMembers((PsiType)thisType, processor, this, true)) break;
            }
            return processor.getCandidates();
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    @Override
    public PsiMethod resolveConstructor() {
        return PsiImplUtil.extractUniqueElement(this.multiResolveConstructor());
    }

    @Override
    public GroovyResolveResult resolveConstructorGenerics() {
        return PsiImplUtil.extractUniqueResult(this.multiResolveConstructor());
    }

    @Override
    public PsiClass getDelegatedClass() {
        GrTypeDefinition typeDefinition = this.getEnclosingClass();
        if (typeDefinition != null) {
            return this.isThisCall() ? typeDefinition : typeDefinition.getSuperClass();
        }
        return null;
    }

    private GrTypeDefinition getEnclosingClass() {
        return (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)this, GrTypeDefinition.class);
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getThisOrSuperKeyword().getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        return this.resolveConstructor();
    }

    public String getCanonicalText() {
        return this.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrConstructorInvocationImpl.bindToElement must not be null");
        }
        return this;
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof PsiMethod && ((PsiMethod)element).isConstructor() && this.getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrConstructorInvocationImpl.getVariants must not return null");
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiReference getReference() {
        return this;
    }
}

