/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTopLevelDefintion;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptMethod;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyScriptClass
extends LightElement
implements GrMemberOwner,
SyntheticElement {
    private final GroovyFile myFile;
    private final PsiMethod myMainMethod;
    private final PsiMethod myRunMethod;
    private static final String MAIN_METHOD_TEXT = "public static final void main(java.lang.String[] args) {}";
    private static final String RUN_METHOD_TEXT = "public java.lang.Object run() {return null;}";

    public GroovyScriptClass(GroovyFile file) {
        super(file.getManager(), file.getLanguage());
        this.myFile = file;
        this.myMainMethod = new GroovyScriptMethod(this, MAIN_METHOD_TEXT);
        this.myRunMethod = new GroovyScriptMethod(this, RUN_METHOD_TEXT);
    }

    public String toString() {
        return "Script Class:" + this.getQualifiedName();
    }

    public String getText() {
        return "class " + this.getName() + " {}";
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass((PsiClass)this);
        }
    }

    public PsiElement copy() {
        return new GroovyScriptClass(this.myFile);
    }

    public PsiFile getContainingFile() {
        return this.myFile;
    }

    public TextRange getTextRange() {
        return this.myFile.getTextRange();
    }

    public boolean isValid() {
        return this.myFile.isValid() && this.myFile.getTopStatements().length > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getQualifiedName() {
        String string;
        String packName = this.myFile.getPackageName();
        if (packName.length() == 0) {
            string = this.getName();
            if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getQualifiedName must not return null");
            return string;
        }
        string = packName + "." + this.getName();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getQualifiedName must not return null");
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.add must not be null");
        }
        return this.myFile.add(element);
    }

    public PsiReferenceList getExtendsList() {
        return null;
    }

    public PsiReferenceList getImplementsList() {
        return null;
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        if (PsiClassType.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getExtendsListTypes must not return null");
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        if (PsiClassType.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getImplementsListTypes must not return null");
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    public PsiClass getSuperClass() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).findClass("groovy.lang.Script", this.getResolveScope());
    }

    public PsiClass[] getInterfaces() {
        return PsiClass.EMPTY_ARRAY;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClass[] getSupers() {
        PsiClass[] psiClassArray;
        PsiClass superClass = this.getSuperClass();
        if (superClass != null) {
            psiClassArray = new PsiClass[]{superClass};
            if (psiClassArray == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getSupers must not return null");
            return psiClassArray;
        }
        psiClassArray = PsiClass.EMPTY_ARRAY;
        if (PsiClass.EMPTY_ARRAY != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getSupers must not return null");
    }

    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = new PsiClassType[]{JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeByFQClassName("groovy.lang.Script", this.getResolveScope())};
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getSuperTypes must not return null");
        }
        return psiClassTypeArray;
    }

    public PsiClass getContainingClass() {
        return null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Set<HierarchicalMethodSignature> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getVisibleSignatures must not return null");
        }
        return set;
    }

    @NotNull
    public PsiField[] getFields() {
        if (PsiField.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getFields must not return null");
        }
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        GrMethod[] methods = this.myFile.getTopLevelMethods();
        PsiMethod[] result = new PsiMethod[methods.length + 2];
        result[0] = this.myMainMethod;
        result[1] = this.myRunMethod;
        System.arraycopy(methods, 0, result, 2, methods.length);
        if (result == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getMethods must not return null");
        }
        return result;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getConstructors must not return null");
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getInnerClasses must not return null");
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getInitializers must not return null");
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getTypeParameters must not return null");
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    @NotNull
    public PsiField[] getAllFields() {
        if (PsiField.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getAllFields must not return null");
        }
        return PsiField.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = this.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getAllMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getAllInnerClasses must not return null");
        }
        return PsiClass.EMPTY_ARRAY;
    }

    public PsiField findFieldByName(String name, boolean checkBases) {
        return null;
    }

    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return null;
    }

    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.findMethodsBySignature must not return null");
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.findMethodsByName must not return null");
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.findMethodsAndTheirSubstitutorsByName must not return null");
        }
        return arrayList;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getAllMethodsAndTheirSubstitutors must not return null");
        }
        return arrayList;
    }

    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return null;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    public boolean hasTypeParameters() {
        return false;
    }

    public PsiJavaToken getLBrace() {
        return null;
    }

    public PsiJavaToken getRBrace() {
        return null;
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    public PsiElement getScope() {
        return this.myFile;
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep((PsiClass)this, (PsiClass)baseClass, (PsiClass)classToByPass);
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.isInheritor must not be null");
        }
        return InheritanceImplUtil.isInheritor((PsiClass)this, (PsiClass)baseClass, (boolean)checkDeep);
    }

    @NotNull
    public String getName() {
        String name = this.myFile.getName();
        int i = name.indexOf(46);
        String string = i > 0 ? name.substring(0, i) : name;
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.getName must not return null");
        }
        return string;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.setName must not be null");
        }
        this.myFile.setName(name + "." + this.myFile.getViewProvider().getVirtualFile().getExtension());
        return this;
    }

    public PsiModifierList getModifierList() {
        return null;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.hasModifierProperty must not be null");
        }
        return "public".equals(name);
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean processDeclarations(final @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GroovyScriptClass.processDeclarations must not be null");
        }
        for (GrTopLevelDefintion defintion : this.myFile.getTopLevelDefinitions()) {
            if (defintion instanceof PsiClass || ResolveUtil.processElement(processor, defintion)) continue;
            return false;
        }
        PsiClass scriptClass = this.getSuperClass();
        return scriptClass == null || scriptClass.processDeclarations((PsiScopeProcessor)new BaseScopeProcessor(){

            public boolean execute(PsiElement element, ResolveState state) {
                return !(element instanceof PsiNamedElement) || ResolveUtil.processElement(processor, (PsiNamedElement)element);
            }

            public <T> T getHint(Key<T> hintKey) {
                return (T)processor.getHint(hintKey);
            }
        }, state, lastParent, place);
    }

    public PsiElement getContext() {
        return this.myFile;
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return GroovyScriptClass.this.getName();
            }

            public String getLocationString() {
                return "(groovy script)";
            }

            public TextAttributesKey getTextAttributesKey() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return GroovyScriptClass.this.myFile.getIcon(0);
            }
        };
    }

    public PsiElement getOriginalElement() {
        return PsiImplUtil.getOriginalElement(this, this.myFile);
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.myFile.getIcon(flags);
    }

    public void checkDelete() throws IncorrectOperationException {
    }

    public void delete() throws IncorrectOperationException {
        this.myFile.delete();
    }

    @Override
    public <T extends GrMembersDeclaration> T addMemberDeclaration(T decl, PsiElement anchorBefore) throws IncorrectOperationException {
        return this.myFile.addMemberDeclaration(decl, anchorBefore);
    }
}

