/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class PropertyResolverProcessor
extends ResolverProcessor {
    private GroovyResolveResult myProperty = null;

    public PropertyResolverProcessor(String name, PsiElement place) {
        super(name, EnumSet.of(ClassHint.ResolveKind.PROPERTY), place, PsiType.EMPTY_ARRAY);
    }

    @Override
    public boolean execute(PsiElement element, ResolveState state) {
        if (element instanceof GrReferenceExpression && ((GrReferenceExpression)element).getQualifier() != null) {
            return true;
        }
        return super.execute(element, state);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCandidates() {
        if (this.myProperty != null) {
            if (this.myCandidates.isEmpty()) {
                this.myCandidates.add(this.myProperty);
            }
            this.myProperty = null;
        }
        GroovyResolveResult[] groovyResolveResultArray = super.getCandidates();
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/resolve/processors/PropertyResolverProcessor.getCandidates must not return null");
        }
        return groovyResolveResultArray;
    }

    @Override
    public boolean hasCandidates() {
        return this.myProperty != null || super.hasCandidates();
    }
}

