/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extractMethod;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ExtractMethodInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ExtractMethodSettings;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ExtractMethodUtil;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.GroovyExtractMethodHandler;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ParameterTablePanel;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.VisibilityPanel;
import org.jetbrains.plugins.groovy.settings.GroovyApplicationSettings;

public class GroovyExtractMethodDialog
extends DialogWrapper {
    private final ExtractMethodInfoHelper myHelper;
    private final Project myProject;
    private final EventListenerList myListenerList;
    private JPanel contentPane;
    private EditorTextField myNameField;
    private JCheckBox myCbSpecifyType;
    private JLabel myNameLabel;
    private JTextArea mySignatureArea;
    private VisibilityPanel myVisibilityPanel;
    private ParameterTablePanel myParameterTablePanel;
    private JButton buttonOK;

    public GroovyExtractMethodDialog(ExtractMethodInfoHelper helper, Project project) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myListenerList = new EventListenerList();
        this.myProject = project;
        this.myHelper = helper;
        this.setUpNameField();
        this.myParameterTablePanel.init(this, this.myHelper);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.setTitle(GroovyExtractMethodHandler.REFACTORING_NAME);
        this.init();
        this.setUpDialog();
        this.update();
    }

    protected void doOKAction() {
        String name = this.getEnteredName();
        if (name == null) {
            return;
        }
        GrMethod method = ExtractMethodUtil.createMethodByHelper(name, this.myHelper);
        if (method != null && !ExtractMethodUtil.validateMethod(method, this.myHelper)) {
            return;
        }
        if (this.myCbSpecifyType.isEnabled()) {
            GroovyApplicationSettings.getInstance().EXTRACT_METHOD_SPECIFY_TYPE = this.myCbSpecifyType.isSelected();
        }
        GroovyApplicationSettings.getInstance().EXTRACT_METHOD_VISIBILITY = this.myVisibilityPanel.getVisibility();
        super.doOKAction();
    }

    private void setUpDialog() {
        this.myCbSpecifyType.setMnemonic(84);
        this.myCbSpecifyType.setFocusable(false);
        this.myCbSpecifyType.setEnabled(this.myHelper.specifyType());
        this.myCbSpecifyType.setSelected(this.myHelper.specifyType());
        if (this.myCbSpecifyType.isEnabled() && GroovyApplicationSettings.getInstance().EXTRACT_METHOD_SPECIFY_TYPE != null) {
            this.myCbSpecifyType.setSelected(GroovyApplicationSettings.getInstance().EXTRACT_METHOD_SPECIFY_TYPE);
        }
        this.myCbSpecifyType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GroovyExtractMethodDialog.this.myHelper.setSpecifyType(GroovyExtractMethodDialog.this.myCbSpecifyType.isSelected());
                GroovyExtractMethodDialog.this.updateSignature();
            }
        });
        this.myHelper.setSpecifyType(this.myCbSpecifyType.isSelected());
        this.myHelper.setVisibility(this.myVisibilityPanel.getVisibility());
        this.myNameLabel.setLabelFor((Component)this.myNameField);
    }

    private void setUpNameField() {
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyExtractMethodDialog.this.myNameField.requestFocus();
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        this.myNameField.addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                GroovyExtractMethodDialog.this.fireNameDataChanged();
            }
        });
        this.myListenerList.add(DataChangedListener.class, new DataChangedListener());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    @NotNull
    protected ExtractMethodInfoHelper getHelper() {
        ExtractMethodInfoHelper extractMethodInfoHelper = this.myHelper;
        if (extractMethodInfoHelper == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/GroovyExtractMethodDialog.getHelper must not return null");
        }
        return extractMethodInfoHelper;
    }

    private void update() {
        String text = this.getEnteredName();
        this.updateSignature();
        this.setOKActionEnabled(GroovyNamesUtil.isIdentifier(text));
    }

    protected String getEnteredName() {
        String text = this.myNameField.getText();
        if (text != null && text.trim().length() > 0) {
            return text.trim();
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.extractMethod");
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    private void createUIComponents() {
        this.myNameField = new EditorTextField("", this.myProject, (FileType)GroovyFileType.GROOVY_FILE_TYPE);
        this.myVisibilityPanel = new VisibilityPanel();
        String visibility = GroovyApplicationSettings.getInstance().EXTRACT_METHOD_VISIBILITY;
        if (visibility == null) {
            visibility = "private";
        }
        this.myVisibilityPanel.setVisibility(visibility);
        this.myVisibilityPanel.addStateChangedListener(new VisibilityPanel.VisibilityStateChanged(){

            @Override
            public void visibilityChanged(String newVisibility) {
                GroovyExtractMethodDialog.this.myHelper.setVisibility(newVisibility);
                GroovyExtractMethodDialog.this.updateSignature();
            }
        });
        this.myParameterTablePanel = new ParameterTablePanel();
    }

    private void fireNameDataChanged() {
        Object[] list;
        for (Object aList : list = this.myListenerList.getListenerList()) {
            if (!(aList instanceof DataChangedListener)) continue;
            ((DataChangedListener)aList).dataChanged();
        }
    }

    void updateSignature() {
        if (this.mySignatureArea == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(ExtractMethodUtil.getModifierString(this.myHelper));
        buffer.append(ExtractMethodUtil.getTypeString(this.myHelper, true));
        String name = this.getEnteredName() == null ? "" : this.getEnteredName();
        buffer.append(name);
        buffer.append("(");
        String[] params = ExtractMethodUtil.getParameterString(this.myHelper);
        if (params.length > 0) {
            String INDENT = "    ";
            buffer.append("\n");
            for (String param : params) {
                buffer.append(INDENT).append(param).append("\n");
            }
        }
        buffer.append(")");
        this.mySignatureArea.setText(buffer.toString());
    }

    ExtractMethodSettings getSettings() {
        GroovyExtractMethodDialog dialog = this;
        return new MyExtractMethodSettings(dialog);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringBundle").getString("method.border.title"), 0, 0, null, null));
        EditorTextField editorTextField = this.myNameField;
        jPanel2.add((Component)editorTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringBundle").getString("name.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbSpecifyType = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringBundle").getString("specify.type.label"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringBundle").getString("signature.preview.border.title"), 0, 0, null, null));
        this.mySignatureArea = jTextArea = new JTextArea();
        ((Component)jTextArea).setBackground(new Color(-1119000));
        jTextArea.setText("");
        jTextArea.setEditable(false);
        jPanel3.add((Component)jTextArea, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        VisibilityPanel visibilityPanel = this.myVisibilityPanel;
        jPanel4.add((Component)visibilityPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        ParameterTablePanel parameterTablePanel = this.myParameterTablePanel;
        jPanel4.add((Component)parameterTablePanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyExtractMethodSettings
    implements ExtractMethodSettings {
        ExtractMethodInfoHelper myHelper;
        String myEnteredName;

        public MyExtractMethodSettings(GroovyExtractMethodDialog dialog) {
            this.myHelper = dialog.getHelper();
            this.myEnteredName = dialog.getEnteredName();
        }

        @Override
        @NotNull
        public ExtractMethodInfoHelper getHelper() {
            ExtractMethodInfoHelper extractMethodInfoHelper = this.myHelper;
            if (extractMethodInfoHelper == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/refactoring/extractMethod/GroovyExtractMethodDialog$MyExtractMethodSettings.getHelper must not return null");
            }
            return extractMethodInfoHelper;
        }

        @Override
        public String getEnteredName() {
            return this.myEnteredName;
        }
    }

    class DataChangedListener
    implements EventListener {
        DataChangedListener() {
        }

        void dataChanged() {
            GroovyExtractMethodDialog.this.update();
        }
    }
}

