/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduceVariable;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduceVariable.GroovyIntroduceVariableBase;
import org.jetbrains.plugins.groovy.refactoring.introduceVariable.GroovyIntroduceVariableDialog;

public class GroovyVariableValidator
implements GroovyIntroduceVariableBase.Validator {
    private final GroovyIntroduceVariableBase myIntroduceVariableBase;
    private final Project myProject;
    private GrExpression myExpression;
    private final GroovyPsiElement myContainer;
    private final PsiElement[] myOccurrences;

    @Override
    public boolean isOK(GroovyIntroduceVariableDialog dialog) {
        boolean allOccurrences;
        String varName = dialog.getEnteredName();
        ArrayList<String> conflicts = this.isOKImpl(varName, allOccurrences = dialog.isReplaceAllOccurrences());
        return conflicts.size() <= 0 || this.myIntroduceVariableBase.reportConflicts(conflicts, this.getProject());
    }

    private ArrayList<String> isOKImpl(String varName, boolean replaceAllOccurrences) {
        if (replaceAllOccurrences) {
            GroovyRefactoringUtil.sortOccurrences(this.myOccurrences);
            this.myExpression = (GrExpression)this.myOccurrences[0];
        }
        ArrayList<String> conflicts = new ArrayList<String>();
        assert (varName != null);
        this.validateVariableOccurrencesDown(this.myContainer, conflicts, varName);
        if (!(this.myContainer instanceof GroovyFileBase)) {
            this.validateVariableOccurrencesUp(this.myContainer, conflicts, varName);
        }
        return conflicts;
    }

    public String isOKTest(String varName, boolean allOccurences) {
        ArrayList<String> list = this.isOKImpl(varName, allOccurences);
        String result = "";
        for (String s : list) {
            result = result + s.replaceAll("<b><code>", "").replaceAll("</code></b>", "") + "\n";
        }
        if (list.size() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.length() == 0) {
            result = "ok";
        }
        return result;
    }

    public GroovyVariableValidator(GroovyIntroduceVariableBase introduceVariableBase, Project project, GrExpression selectedExpr, PsiElement[] occurrences, GroovyPsiElement enclosingContainer) {
        this.myIntroduceVariableBase = introduceVariableBase;
        this.myOccurrences = occurrences;
        this.myProject = project;
        this.myExpression = selectedExpr;
        this.myContainer = enclosingContainer;
    }

    private void validateVariableOccurrencesDown(PsiElement startElement, ArrayList<String> conflicts, @NotNull String varName) {
        if (varName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/introduceVariable/GroovyVariableValidator.validateVariableOccurrencesDown must not be null");
        }
        PsiElement child = startElement.getFirstChild();
        while (child != null) {
            if (child instanceof GrTypeDefinition || child instanceof GrMethod || GroovyRefactoringUtil.isAppropriateContainerForIntroduceVariable(child) && child.getTextRange().getEndOffset() < this.myExpression.getTextRange().getStartOffset()) {
                child = child.getNextSibling();
                continue;
            }
            if (child instanceof GrVariable) {
                if (child instanceof GrField) {
                    return;
                }
                if (child instanceof GrParameter && varName.equals(((GrParameter)child).getName())) {
                    conflicts.add(GroovyRefactoringBundle.message("introduced.variable.conflicts.with.parameter.0", CommonRefactoringUtil.htmlEmphasize((String)varName)));
                    return;
                }
                if (varName.equals(((GrVariable)child).getName())) {
                    conflicts.add(GroovyRefactoringBundle.message("introduced.variable.conflicts.with.variable.0", CommonRefactoringUtil.htmlEmphasize((String)varName)));
                    return;
                }
                this.validateVariableOccurrencesDown(child, conflicts, varName);
            } else {
                this.validateVariableOccurrencesDown(child, conflicts, varName);
            }
            child = child.getNextSibling();
        }
    }

    private void validateVariableOccurrencesUp(PsiElement startElement, ArrayList<String> conflicts, @NotNull String varName) {
        if (varName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/refactoring/introduceVariable/GroovyVariableValidator.validateVariableOccurrencesUp must not be null");
        }
        for (PsiElement prevSibling = startElement.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
            this.validateVariableOccurrencesDown(prevSibling, conflicts, varName);
        }
        PsiElement parent = startElement.getParent();
        if (parent == null || parent instanceof GrMethod || parent instanceof GrTypeDefinition || parent instanceof GroovyFileBase || parent instanceof PsiDirectory) {
            return;
        }
        this.validateVariableOccurrencesUp(parent, conflicts, varName);
    }

    @Override
    public String validateName(String name, boolean increaseNumber) {
        String result = name;
        if (!this.isOKTest(name, true).equals("ok") && !increaseNumber || name.length() == 0) {
            return "";
        }
        int i = 1;
        while (!this.isOKTest(result, true).equals("ok")) {
            result = name + i;
            ++i;
        }
        return result;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }
}

