/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.validation;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.lang.ant.validation.AntInspection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntDuplicateTargetsInspection
extends AntInspection {
    @NonNls
    private static final String SHORT_NAME = "AntDuplicateTargetsInspection";

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AntBundle.message("ant.duplicate.targets.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/validation/AntDuplicateTargetsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/validation/AntDuplicateTargetsInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        AntTarget[] targets;
        AntProject project;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/validation/AntDuplicateTargetsInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/validation/AntDuplicateTargetsInspection.checkFile must not be null");
        }
        if (file instanceof AntFile && (project = ((AntFile)file).getAntProject()) != null && (targets = project.getTargets()).length > 0) {
            HashMap<String, AntTarget> name2Target = new HashMap<String, AntTarget>();
            ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
            for (AntTarget target : targets) {
                String name = target.getName();
                AntTarget t = (AntTarget)name2Target.get(name);
                if (t != null) {
                    String duplicatedMessage = AntBundle.message("target.is.duplicated", name);
                    problems.add(manager.createProblemDescriptor((PsiElement)target, duplicatedMessage, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    problems.add(manager.createProblemDescriptor((PsiElement)t, duplicatedMessage, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
                name2Target.put(name, target);
            }
            int prolemCount = problems.size();
            if (prolemCount > 0) {
                return problems.toArray(new ProblemDescriptor[prolemCount]);
            }
        }
        return null;
    }
}

