/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.pathMacros;

import com.intellij.application.options.pathMacros.PathMacroListEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.IconLoader;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PathMacroConfigurable
implements SearchableConfigurable {
    public static final Icon ICON = IconLoader.getIcon((String)"/general/pathVariables.png");
    @NonNls
    public static final String HELP_ID = "preferences.pathVariables";
    private PathMacroListEditor myEditor;

    public JComponent createComponent() {
        this.myEditor = new PathMacroListEditor();
        return this.myEditor.getPanel();
    }

    public void apply() throws ConfigurationException {
        Project[] projects;
        this.myEditor.commit();
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            ((ProjectEx)project).checkUnknownMacros(false);
        }
    }

    public void reset() {
        this.myEditor.reset();
    }

    public void disposeUIResources() {
        this.myEditor = null;
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"title.path.variables", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return HELP_ID;
    }

    public boolean isModified() {
        return this.myEditor.isModified();
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getId() {
        return this.getHelpTopic();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }
}

