/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorHighlightingPass
implements HighlightingPass {
    public static final TextEditorHighlightingPass[] EMPTY_ARRAY = new TextEditorHighlightingPass[0];
    protected final Document myDocument;
    protected final Project myProject;
    private final boolean myRunIntentionPassAfter;
    private final long myInitialStamp;
    private int[] myCompletionPredecessorIds;
    private int[] myStartingPredecessorIds;
    private int myId;
    private boolean myDumb;

    protected TextEditorHighlightingPass(@NotNull Project project, @Nullable Document document, boolean runIntentionPassAfter) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeHighlighting/TextEditorHighlightingPass.<init> must not be null");
        }
        this.myCompletionPredecessorIds = ArrayUtil.EMPTY_INT_ARRAY;
        this.myStartingPredecessorIds = ArrayUtil.EMPTY_INT_ARRAY;
        this.myDocument = document;
        this.myProject = project;
        this.myRunIntentionPassAfter = runIntentionPassAfter;
        this.myInitialStamp = document == null ? 0L : document.getModificationStamp();
    }

    protected TextEditorHighlightingPass(@NotNull Project project, @Nullable Document document) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeHighlighting/TextEditorHighlightingPass.<init> must not be null");
        }
        this(project, document, true);
    }

    public final void collectInformation(ProgressIndicator progress) {
        if (!this.isValid()) {
            return;
        }
        this.myDumb = DumbService.getInstance((Project)this.myProject).isDumb();
        this.doCollectInformation(progress);
    }

    protected boolean isDumbMode() {
        return this.myDumb;
    }

    private boolean isValid() {
        PsiFile file;
        if (this.isDumbMode() && !(this instanceof DumbAware)) {
            return false;
        }
        if (this.myDocument != null && this.myDocument.getModificationStamp() != this.myInitialStamp) {
            return false;
        }
        return this.myProject == null || this.myDocument == null || (file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument)) != null && file.isValid();
    }

    public final void applyInformationToEditor() {
        if (!this.isValid()) {
            return;
        }
        this.doApplyInformationToEditor();
    }

    public abstract void doCollectInformation(ProgressIndicator var1);

    public abstract void doApplyInformationToEditor();

    public final int getId() {
        return this.myId;
    }

    public final void setId(int id) {
        this.myId = id;
    }

    @NotNull
    public final int[] getCompletionPredecessorIds() {
        if (this.myCompletionPredecessorIds == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeHighlighting/TextEditorHighlightingPass.getCompletionPredecessorIds must not return null");
        }
        return this.myCompletionPredecessorIds;
    }

    public final void setCompletionPredecessorIds(@NotNull int[] completionPredecessorIds) {
        if (completionPredecessorIds == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeHighlighting/TextEditorHighlightingPass.setCompletionPredecessorIds must not be null");
        }
        this.myCompletionPredecessorIds = completionPredecessorIds;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    @NotNull
    public final int[] getStartingPredecessorIds() {
        if (this.myStartingPredecessorIds == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeHighlighting/TextEditorHighlightingPass.getStartingPredecessorIds must not return null");
        }
        return this.myStartingPredecessorIds;
    }

    public final void setStartingPredecessorIds(@NotNull int[] startingPredecessorIds) {
        if (startingPredecessorIds == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeHighlighting/TextEditorHighlightingPass.setStartingPredecessorIds must not be null");
        }
        this.myStartingPredecessorIds = startingPredecessorIds;
    }

    @NonNls
    public String toString() {
        return this.getClass() + "; id=" + this.getId();
    }

    public boolean isRunIntentionPassAfter() {
        return this.myRunIntentionPassAfter;
    }
}

