/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiThisExpression;
import org.jetbrains.annotations.NotNull;

public class PreferLocalVariablesLiteralsAndAnnoMethodsWeigher
extends CompletionWeigher {
    public MyResult weigh(@NotNull LookupElement item, CompletionLocation location) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/PreferLocalVariablesLiteralsAndAnnoMethodsWeigher.weigh must not be null");
        }
        Object object = item.getObject();
        if (location.getCompletionType() == CompletionType.SMART) {
            if (object instanceof PsiLocalVariable || object instanceof PsiParameter || object instanceof PsiThisExpression) {
                return MyResult.localOrParameter;
            }
            if (object instanceof String && item.getUserData(JavaCompletionUtil.SUPER_METHOD_PARAMETERS) == Boolean.TRUE) {
                return MyResult.superMethodParameters;
            }
            return MyResult.normal;
        }
        if (location.getCompletionType() == CompletionType.BASIC) {
            if (object instanceof PsiKeyword && "class".equals(item.getLookupString())) {
                return MyResult.classLiteral;
            }
            if (object instanceof PsiAnnotationMethod && ((PsiAnnotationMethod)object).getContainingClass().isAnnotationType()) {
                return MyResult.annoMethod;
            }
        }
        return MyResult.normal;
    }

    static enum MyResult {
        classLiteral,
        normal,
        superMethodParameters,
        localOrParameter,
        annoMethod;

    }
}

