/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IdentifierHighlighterPass
extends TextEditorHighlightingPass {
    private final PsiFile myFile;
    private final Editor myEditor;
    private final Collection<TextRange> myReadAccessRanges = new ArrayList<TextRange>();
    private final Collection<TextRange> myWriteAccessRanges = new ArrayList<TextRange>();
    private final int myCaretOffset;
    private static final HighlightInfoType ourReadHighlightInfoType = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES);
    private static final HighlightInfoType ourWriteHighlightInfoType = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES);

    protected IdentifierHighlighterPass(Project project, PsiFile file, Editor editor) {
        super(project, editor.getDocument(), false);
        this.myFile = file;
        this.myEditor = editor;
        this.myCaretOffset = this.myEditor.getCaretModel().getOffset();
    }

    @Override
    public void doCollectInformation(ProgressIndicator progress) {
        Editor injectedEditor;
        if (!CodeInsightSettings.getInstance().HIGHLIGHT_IDENTIFIER_UNDER_CARET) {
            return;
        }
        HighlightUsagesHandlerBase handler = HighlightUsagesHandler.createCustomHandler(this.myEditor, this.myFile);
        if (handler != null) {
            List targets = handler.getTargets();
            handler.computeUsages(targets);
            this.myReadAccessRanges.addAll(handler.getReadUsages());
            this.myWriteAccessRanges.addAll(handler.getWriteUsages());
            return;
        }
        int flags = 3;
        PsiElement myTarget = TargetElementUtilBase.getInstance().findTargetElement(this.myEditor, flags, this.myCaretOffset);
        if (myTarget == null && !PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(this.myEditor.getDocument()) && (injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(this.myEditor, this.myFile, this.myCaretOffset)) != null) {
            myTarget = TargetElementUtilBase.getInstance().findTargetElement(injectedEditor, flags, injectedEditor.getCaretModel().getOffset());
        }
        if (myTarget != null) {
            final ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)myTarget);
            final PsiElement finalMyTarget = myTarget;
            ReferencesSearch.search((PsiElement)myTarget, (SearchScope)new LocalSearchScope((PsiElement)this.myFile)).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference psiReference) {
                    TextRange textRange = HighlightUsagesHandler.getRangeToHighlight(psiReference);
                    if (detector == null || detector.getReferenceAccess(finalMyTarget, psiReference) == ReadWriteAccessDetector.Access.Read) {
                        IdentifierHighlighterPass.this.myReadAccessRanges.add(textRange);
                    } else {
                        IdentifierHighlighterPass.this.myWriteAccessRanges.add(textRange);
                    }
                    return true;
                }
            });
            TextRange declRange = HighlightUsagesHandler.getNameIdentifierRange(this.myFile, myTarget);
            if (declRange != null) {
                if (detector != null && detector.isDeclarationWriteAccess(myTarget)) {
                    this.myWriteAccessRanges.add(declRange);
                } else {
                    this.myReadAccessRanges.add(declRange);
                }
            }
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        boolean virtSpace = TargetElementUtilBase.inVirtualSpace(this.myEditor, this.myEditor.getCaretModel().getOffset());
        List<HighlightInfo> infos = virtSpace ? Collections.emptyList() : this.getHighlights();
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, 0, this.myFile.getTextLength(), infos, this.getId());
    }

    private List<HighlightInfo> getHighlights() {
        if (this.myReadAccessRanges.isEmpty() && this.myWriteAccessRanges.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(this.myReadAccessRanges.size() + this.myWriteAccessRanges.size());
        for (TextRange range : this.myReadAccessRanges) {
            ContainerUtil.addIfNotNull((Object)HighlightInfo.createHighlightInfo(ourReadHighlightInfoType, range, null), result);
        }
        for (TextRange range : this.myWriteAccessRanges) {
            ContainerUtil.addIfNotNull((Object)HighlightInfo.createHighlightInfo(ourWriteHighlightInfoType, range, null), result);
        }
        return result;
    }

    public static void clearMyHighlights(Document document, Project project) {
        MarkupModel markupModel = document.getMarkupModel(project);
        List<HighlightInfo> old = DaemonCodeAnalyzerImpl.getHighlights(document, project);
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(old == null ? Collections.emptyList() : old);
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            Object tooltip = highlighter.getErrorStripeTooltip();
            if (!(tooltip instanceof HighlightInfo)) continue;
            HighlightInfo info = (HighlightInfo)tooltip;
            if (info.type != ourReadHighlightInfoType && info.type != ourWriteHighlightInfoType) continue;
            result.remove(info);
            markupModel.removeHighlighter(highlighter);
        }
        DaemonCodeAnalyzerImpl.setHighlights(markupModel, project, result, Collections.<HighlightInfo>emptyList());
    }
}

