/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

public abstract class PerThreadMap<T, KeyT extends UserDataHolder> {
    private volatile int version;
    private final ThreadLocal<Pair<Integer, Map<KeyT, List<T>>>> CACHE = new ThreadLocal<Pair<Integer, Map<KeyT, List<T>>>>(){

        @Override
        protected Pair<Integer, Map<KeyT, List<T>>> initialValue() {
            return Pair.create((Object)PerThreadMap.this.version, (Object)new THashMap());
        }
    };

    @NotNull
    public abstract Collection<T> initialValue(@NotNull KeyT var1);

    private List<T> cloneTemplates(Collection<T> templates) {
        ArrayList<Object> result = new ArrayList<Object>(templates.size());
        PicoContainer container = ApplicationManager.getApplication().getPicoContainer();
        for (T template : templates) {
            Class<?> aClass = template.getClass();
            Object clone = new ConstructorInjectionComponentAdapter((Object)aClass.getName(), aClass).getComponentInstance(container);
            result.add(clone);
        }
        return result;
    }

    @NotNull
    public List<T> get(@NotNull KeyT key) {
        Map map;
        List<T> cached;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PerThreadMap.get must not be null");
        }
        Pair<Integer, Map<KeyT, List<T>>> pair = this.CACHE.get();
        Integer mapVersion = (Integer)pair.getFirst();
        if (this.version != mapVersion) {
            this.CACHE.remove();
            pair = this.CACHE.get();
        }
        if ((cached = (List<T>)(map = (Map)pair.getSecond()).get(key)) == null) {
            Collection<T> templates = this.initialValue(key);
            cached = this.cloneTemplates(templates);
            map.put(key, cached);
        }
        List<T> list = cached;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/PerThreadMap.get must not return null");
        }
        return list;
    }

    public void clear() {
        ++this.version;
    }
}

