/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.XmlQuoteHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;

public class HtmlQuoteHandler
implements QuoteHandler {
    private static QuoteHandler ourStyleQuoteHandler;
    private QuoteHandler myBaseQuoteHandler;
    private static QuoteHandler ourScriptQuoteHandler;

    public HtmlQuoteHandler() {
        this(new XmlQuoteHandler());
    }

    public HtmlQuoteHandler(QuoteHandler _baseHandler) {
        this.myBaseQuoteHandler = _baseHandler;
    }

    public static void setStyleQuoteHandler(QuoteHandler quoteHandler) {
        ourStyleQuoteHandler = quoteHandler;
    }

    @Override
    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (this.myBaseQuoteHandler.isClosingQuote(iterator, offset)) {
            return true;
        }
        if (ourStyleQuoteHandler != null && ourStyleQuoteHandler.isClosingQuote(iterator, offset)) {
            return true;
        }
        return ourScriptQuoteHandler != null && ourScriptQuoteHandler.isClosingQuote(iterator, offset);
    }

    @Override
    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (this.myBaseQuoteHandler.isOpeningQuote(iterator, offset)) {
            return true;
        }
        if (ourStyleQuoteHandler != null && ourStyleQuoteHandler.isOpeningQuote(iterator, offset)) {
            return true;
        }
        return ourScriptQuoteHandler != null && ourScriptQuoteHandler.isOpeningQuote(iterator, offset);
    }

    @Override
    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        if (this.myBaseQuoteHandler.hasNonClosedLiteral(editor, iterator, offset)) {
            return true;
        }
        if (ourStyleQuoteHandler != null && ourStyleQuoteHandler.hasNonClosedLiteral(editor, iterator, offset)) {
            return true;
        }
        return ourScriptQuoteHandler != null && ourScriptQuoteHandler.hasNonClosedLiteral(editor, iterator, offset);
    }

    @Override
    public boolean isInsideLiteral(HighlighterIterator iterator) {
        if (this.myBaseQuoteHandler.isInsideLiteral(iterator)) {
            return true;
        }
        if (ourStyleQuoteHandler != null && ourStyleQuoteHandler.isInsideLiteral(iterator)) {
            return true;
        }
        return ourScriptQuoteHandler != null && ourScriptQuoteHandler.isInsideLiteral(iterator);
    }

    public static void setScriptQuoteHandler(QuoteHandler scriptQuoteHandler) {
        ourScriptQuoteHandler = scriptQuoteHandler;
    }
}

