/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;

public class PlainEnterProcessor
implements EnterProcessor {
    @Override
    public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
        PsiCodeBlock block = this.getControlStatementBlock(editor.getCaretModel().getOffset(), psiElement);
        if (block != null) {
            PsiElement firstElement = block.getFirstBodyElement();
            if (firstElement == null) {
                firstElement = block.getRBrace();
            }
            editor.getCaretModel().moveToOffset(firstElement != null ? firstElement.getTextRange().getStartOffset() : block.getTextRange().getEndOffset());
        }
        this.getEnterHandler().execute(editor, ((EditorEx)editor).getDataContext());
        return true;
    }

    private EditorActionHandler getEnterHandler() {
        EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
        return enterHandler;
    }

    private PsiCodeBlock getControlStatementBlock(int caret, PsiElement element) {
        PsiStatement body = null;
        if (element instanceof PsiIfStatement) {
            body = ((PsiIfStatement)element).getThenBranch();
            if (caret > body.getTextRange().getEndOffset()) {
                body = ((PsiIfStatement)element).getElseBranch();
            }
        } else if (element instanceof PsiWhileStatement) {
            body = ((PsiWhileStatement)element).getBody();
        } else if (element instanceof PsiForStatement) {
            body = ((PsiForStatement)element).getBody();
        } else if (element instanceof PsiForeachStatement) {
            body = ((PsiForeachStatement)element).getBody();
        } else if (element instanceof PsiDoWhileStatement) {
            body = ((PsiDoWhileStatement)element).getBody();
        }
        return body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : null;
    }
}

