/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaPsiElementResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableOfTypeMacro
implements Macro {
    public String getName() {
        return "variableOfType";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.variable.of.type", (Object[])new Object[0]);
    }

    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/VariableOfTypeMacro.calculateResult must not be null");
        }
        PsiElement[] vars = VariableOfTypeMacro.getVariables(params, context);
        if (vars == null || vars.length == 0) {
            return null;
        }
        return new JavaPsiElementResult(vars[0]);
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/VariableOfTypeMacro.calculateQuickResult must not be null");
        }
        return null;
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/VariableOfTypeMacro.calculateLookupItems must not be null");
        }
        PsiElement[] vars = VariableOfTypeMacro.getVariables(params, context);
        if (vars == null || vars.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
        for (PsiElement var : vars) {
            JavaTemplateUtil.addElementLookupItem(set, var);
        }
        return set.toArray(new LookupElement[set.size()]);
    }

    @Nullable
    private static PsiElement[] getVariables(Expression[] params, ExpressionContext context) {
        if (params.length != 1) {
            return null;
        }
        Result result = params[0].calculateResult(context);
        if (result == null) {
            return null;
        }
        Project project = context.getProject();
        int offset = context.getStartOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ArrayList<Object> array = new ArrayList<Object>();
        PsiType type = MacroUtil.resultToPsiType(result, context);
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement place = file.findElementAt(offset);
        PsiVariable[] variables = MacroUtil.getVariablesVisibleAt(place, "");
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (PsiVariable var : variables) {
            TextRange range;
            PsiClass placeClass;
            PsiClass varClass;
            if (var instanceof PsiField && var.hasModifierProperty("static") ? !manager.areElementsEquivalent((PsiElement)(varClass = ((PsiField)var).getContainingClass()), (PsiElement)(placeClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class))) : var instanceof PsiLocalVariable && (range = var.getNameIdentifier().getTextRange()) != null && range.contains(offset)) continue;
            PsiType type1 = var.getType();
            if (type != null && !type.isAssignableFrom(type1)) continue;
            array.add(var);
        }
        PsiExpression[] expressions = MacroUtil.getStandardExpressionsOfType(place, type);
        array.addAll(Arrays.asList(expressions));
        return array.toArray(new PsiElement[array.size()]);
    }
}

