/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefEntityImpl
implements RefEntity {
    private static final String NO_NAME = InspectionsBundle.message((String)"inspection.reference.noname", (Object[])new Object[0]);
    private RefEntityImpl myOwner;
    protected ArrayList<RefEntity> myChildren;
    private final String myName;
    private THashMap myUserMap = null;
    protected int myFlags = 0;
    protected final RefManagerImpl myManager;

    protected RefEntityImpl(String name, RefManager manager) {
        this.myManager = (RefManagerImpl)manager;
        this.myName = name != null ? name : NO_NAME;
        this.myOwner = null;
        this.myChildren = null;
    }

    public String getName() {
        return this.myName;
    }

    public String getQualifiedName() {
        return this.myName;
    }

    public List<RefEntity> getChildren() {
        return this.myChildren;
    }

    public RefEntity getOwner() {
        return this.myOwner;
    }

    protected void setOwner(RefEntityImpl owner) {
        this.myOwner = owner;
    }

    public void add(RefEntity child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList();
        }
        this.myChildren.add(child);
        ((RefEntityImpl)child).setOwner(this);
    }

    protected void removeChild(RefEntity child) {
        if (this.myChildren != null) {
            this.myChildren.remove(child);
            ((RefEntityImpl)child).setOwner(null);
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/reference/RefEntityImpl.getUserData must not be null");
        }
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            if (this.myUserMap == null) {
                return null;
            }
            return (T)this.myUserMap.get(key);
        }
    }

    public void accept(final RefVisitor refVisitor) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                refVisitor.visitElement((RefEntity)RefEntityImpl.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/reference/RefEntityImpl.putUserData must not be null");
        }
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            if (this.myUserMap == null) {
                if (value == null) {
                    return;
                }
                this.myUserMap = new THashMap();
            }
            if (value != null) {
                this.myUserMap.put(key, value);
            } else {
                this.myUserMap.remove(key);
                if (this.myUserMap.isEmpty()) {
                    this.myUserMap = null;
                }
            }
        }
    }

    public boolean checkFlag(int mask) {
        return (this.myFlags & mask) != 0;
    }

    public void setFlag(boolean b, int mask) {
        this.myFlags = b ? (this.myFlags |= mask) : (this.myFlags &= ~mask);
    }

    public String getExternalName() {
        return this.myName;
    }

    public RefManagerImpl getRefManager() {
        return this.myManager;
    }
}

