/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BreakException;
import com.intellij.debugger.engine.evaluation.expression.ContinueException;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.openapi.util.Comparing;
import com.sun.jdi.BooleanValue;

public class WhileStatementEvaluator
implements Evaluator {
    private final Evaluator myConditionEvaluator;
    private final Evaluator myBodyEvaluator;
    private final String myLabelName;

    public WhileStatementEvaluator(Evaluator conditionEvaluator, Evaluator bodyEvaluator, String labelName) {
        this.myConditionEvaluator = conditionEvaluator;
        this.myBodyEvaluator = bodyEvaluator;
        this.myLabelName = labelName;
    }

    @Override
    public Modifier getModifier() {
        return this.myConditionEvaluator.getModifier();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        while (true) {
            Object value;
            if (!((value = this.myConditionEvaluator.evaluate(context)) instanceof BooleanValue)) {
                throw EvaluateExceptionUtil.BOOLEAN_EXPECTED;
            }
            if (!((BooleanValue)value).booleanValue()) return value;
            try {
                this.myBodyEvaluator.evaluate(context);
                continue;
            }
            catch (BreakException e) {
                if (Comparing.equal((String)e.getLabelName(), (String)this.myLabelName)) return value;
                throw e;
            }
            catch (ContinueException e) {
                if (!Comparing.equal((String)e.getLabelName(), (String)this.myLabelName)) throw e;
                continue;
            }
            break;
        }
    }
}

