/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutorRegistryImpl
extends ExecutorRegistry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.ExecutorRegistryImpl");
    @NonNls
    public static final String RUNNERS_GROUP = "RunnerActions";
    @NonNls
    public static final String RUN_CONTEXT_GROUP = "RunContextGroup";
    private List<Executor> myExecutors = new ArrayList<Executor>();
    private ActionManager myActionManager;
    private final Map<String, Executor> myId2Executor = new HashMap();
    private final Set<String> myContextActionIdSet = new HashSet();
    private final Map<String, AnAction> myId2Action = new HashMap();
    private final Map<String, AnAction> myContextActionId2Action = new HashMap();

    public ExecutorRegistryImpl(ActionManager actionManager) {
        this.myActionManager = actionManager;
    }

    synchronized void initExecutor(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl.initExecutor must not be null");
        }
        if (this.myId2Executor.get(executor.getId()) != null) {
            LOG.error("Executor with id: \"" + executor.getId() + "\" was already registered!");
        }
        if (this.myContextActionIdSet.contains(executor.getContextActionId())) {
            LOG.error("Executor with context action id: \"" + executor.getContextActionId() + "\" was already registered!");
        }
        this.myExecutors.add(executor);
        this.myId2Executor.put(executor.getId(), executor);
        this.myContextActionIdSet.add(executor.getContextActionId());
        this.registerAction(executor.getId(), new ExecutorAction(executor), RUNNERS_GROUP, this.myId2Action);
        this.registerAction(executor.getContextActionId(), (AnAction)new RunContextAction(executor), RUN_CONTEXT_GROUP, this.myContextActionId2Action);
    }

    private void registerAction(@NotNull String actionId, @NotNull AnAction anAction, @NotNull String groupId, @NotNull Map<String, AnAction> map) {
        if (actionId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl.registerAction must not be null");
        }
        if (anAction == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl.registerAction must not be null");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl.registerAction must not be null");
        }
        if (map == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl.registerAction must not be null");
        }
        AnAction action = this.myActionManager.getAction(actionId);
        if (action == null) {
            this.myActionManager.registerAction(actionId, anAction);
            map.put(actionId, anAction);
            action = anAction;
        }
        DefaultActionGroup group = (DefaultActionGroup)this.myActionManager.getAction(groupId);
        group.add(action);
    }

    synchronized void deinitExecutor(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl.deinitExecutor must not be null");
        }
        this.myExecutors.remove(executor);
        this.myId2Executor.remove(executor.getId());
        this.myContextActionIdSet.remove(executor.getContextActionId());
        this.unregisterAction(executor.getId(), RUNNERS_GROUP, this.myId2Action);
        this.unregisterAction(executor.getContextActionId(), RUN_CONTEXT_GROUP, this.myContextActionId2Action);
    }

    private void unregisterAction(@NotNull String actionId, @NotNull String groupId, @NotNull Map<String, AnAction> map) {
        if (actionId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl.unregisterAction must not be null");
        }
        if (groupId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl.unregisterAction must not be null");
        }
        if (map == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl.unregisterAction must not be null");
        }
        DefaultActionGroup group = (DefaultActionGroup)this.myActionManager.getAction(groupId);
        if (group != null) {
            group.remove(this.myActionManager.getAction(actionId));
            AnAction action = map.get(actionId);
            if (action != null) {
                this.myActionManager.unregisterAction(actionId);
                map.remove(actionId);
            }
        }
    }

    @NotNull
    public synchronized Executor[] getRegisteredExecutors() {
        Executor[] executorArray = this.myExecutors.toArray(new Executor[this.myExecutors.size()]);
        if (executorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ExecutorRegistryImpl.getRegisteredExecutors must not return null");
        }
        return executorArray;
    }

    public Executor getExecutorById(String executorId) {
        return this.myId2Executor.get(executorId);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ExecutorRegistyImpl" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/ExecutorRegistryImpl.getComponentName must not return null");
        }
        return "ExecutorRegistyImpl";
    }

    public void initComponent() {
        Executor[] executors;
        for (Executor executor : executors = (Executor[])Extensions.getExtensions((ExtensionPointName)Executor.EXECUTOR_EXTENSION_NAME)) {
            this.initExecutor(executor);
        }
    }

    public synchronized void disposeComponent() {
        if (this.myExecutors.size() > 0) {
            ArrayList<Executor> executors = new ArrayList<Executor>(this.myExecutors);
            for (Executor executor : executors) {
                this.deinitExecutor(executor);
            }
            this.myExecutors = null;
        }
        this.myActionManager = null;
    }

    private static class ExecutorAction
    extends AnAction
    implements DumbAware {
        private final Executor myExecutor;

        private ExecutorAction(@NotNull Executor executor) {
            if (executor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl$ExecutorAction.<init> must not be null");
            }
            super(executor.getStartActionText(), executor.getActionName(), executor.getIcon());
            this.myExecutor = executor;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            boolean enabled = false;
            Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null || !project.isInitialized() || project.isDisposed() || DumbService.getInstance((Project)project).isDumb()) {
                presentation.setEnabled(false);
                return;
            }
            RunnerAndConfigurationSettingsImpl selectedConfiguration = ExecutorAction.getConfiguration(project);
            if (selectedConfiguration != null) {
                ProgramRunner runner = RunnerRegistry.getInstance().getRunner(this.myExecutor.getId(), (RunProfile)selectedConfiguration.getConfiguration());
                boolean bl = enabled = runner != null;
                if (enabled) {
                    presentation.setDescription(this.myExecutor.getDescription());
                }
            }
            String text = this.getTemplatePresentation().getTextWithMnemonic();
            presentation.setEnabled(enabled);
            presentation.setText(text);
        }

        @Nullable
        private static RunnerAndConfigurationSettingsImpl getConfiguration(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/ExecutorRegistryImpl$ExecutorAction.getConfiguration must not be null");
            }
            return RunManagerEx.getInstanceEx(project).getSelectedConfiguration();
        }

        public void actionPerformed(AnActionEvent e) {
            DataContext dataContext = e.getDataContext();
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            if (project == null || project.isDisposed()) {
                return;
            }
            ExecutionUtil.executeConfiguration(project, ExecutorAction.getConfiguration(project), this.myExecutor);
        }
    }
}

