/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.Nullable;

public abstract class BrowseModuleValueActionListener
implements ActionListener {
    private TextFieldWithBrowseButton myField;
    private final Project myProject;

    protected BrowseModuleValueActionListener(Project project) {
        this.myProject = project;
    }

    public void setField(TextFieldWithBrowseButton field) {
        this.myField = field;
        this.myField.addActionListener((ActionListener)this);
        this.myField.setButtonEnabled(!this.myProject.isDefault());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String text = this.showDialog();
        if (text != null) {
            this.myField.getTextField().setText(text);
        }
    }

    public String getText() {
        return this.myField.getText();
    }

    public TextFieldWithBrowseButton getField() {
        return this.myField;
    }

    @Nullable
    protected abstract String showDialog();

    public Project getProject() {
        return this.myProject;
    }

    public void detach() {
        if (this.myField != null) {
            this.myField.removeActionListener((ActionListener)this);
            this.myField = null;
        }
    }
}

