/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiPackage;
import java.util.Map;

public final class PackageElement
implements Queryable {
    public static final DataKey<PackageElement> DATA_KEY = DataKey.create((String)"package.element");
    private final Module myModule;
    private final PsiPackage myElement;
    private final boolean myIsLibraryElement;

    public PackageElement(Module module, PsiPackage element, boolean isLibraryElement) {
        this.myModule = module;
        this.myElement = element;
        this.myIsLibraryElement = isLibraryElement;
    }

    public Module getModule() {
        return this.myModule;
    }

    public PsiPackage getPackage() {
        return this.myElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageElement)) {
            return false;
        }
        PackageElement packageElement = (PackageElement)o;
        if (this.myIsLibraryElement != packageElement.myIsLibraryElement) {
            return false;
        }
        if (this.myElement != null ? !this.myElement.equals(packageElement.myElement) : packageElement.myElement != null) {
            return false;
        }
        return !(this.myModule != null ? !this.myModule.equals(packageElement.myModule) : packageElement.myModule != null);
    }

    public int hashCode() {
        int result = this.myModule != null ? this.myModule.hashCode() : 0;
        result = 29 * result + (this.myElement != null ? this.myElement.hashCode() : 0);
        result = 29 * result + (this.myIsLibraryElement ? 1 : 0);
        return result;
    }

    public boolean isLibraryElement() {
        return this.myIsLibraryElement;
    }

    public void putInfo(Map<String, String> info) {
        PsiPackage pkg = this.getPackage();
        if (pkg instanceof Queryable) {
            ((Queryable)pkg).putInfo(info);
        }
    }
}

