/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.AppTopics;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.AllTodosTreeBuilder;
import com.intellij.ide.todo.ChangeListTodosPanel;
import com.intellij.ide.todo.ChangeListTodosTreeBuilder;
import com.intellij.ide.todo.CurrentFileTodosPanel;
import com.intellij.ide.todo.CurrentFileTodosTreeBuilder;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

@State(name="TodoView", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class TodoView
implements PersistentStateComponent<Element>,
Disposable {
    private final Project myProject;
    private final ProjectLevelVcsManager myVCSManager;
    private ContentManager myContentManager;
    private CurrentFileTodosPanel myCurrentFileTodos;
    private TodoPanel myAllTodos;
    private ChangeListTodosPanel myChangeListTodos;
    private int mySelectedIndex;
    private final TodoPanelSettings myCurrentPanelSettings;
    private final TodoPanelSettings myAllPanelSettings;
    private final TodoPanelSettings myChangeListTodosPanelSettings;
    @NonNls
    private static final String ATTRIBUTE_SELECTED_INDEX = "selected-index";
    @NonNls
    private static final String ELEMENT_TODO_PANEL = "todo-panel";
    @NonNls
    private static final String ATTRIBUTE_ID = "id";
    @NonNls
    private static final String VALUE_SELECTED_FILE = "selected-file";
    @NonNls
    private static final String VALUE_ALL = "all";
    @NonNls
    private static final String VALUE_DEFAULT_CHANGELIST = "default-changelist";
    private Content myChangeListTodosContent;
    private final MyVcsListener myVcsListener = new MyVcsListener();

    TodoView(Project project, ProjectLevelVcsManager manager) {
        this.myProject = project;
        this.myVCSManager = manager;
        this.myCurrentPanelSettings = new TodoPanelSettings();
        this.myAllPanelSettings = new TodoPanelSettings();
        this.myChangeListTodosPanelSettings = new TodoPanelSettings();
        this.myVCSManager.addVcsListener((VcsListener)this.myVcsListener);
        final MyPropertyChangeListener myPropertyChangeListener = new MyPropertyChangeListener();
        TodoConfiguration.getInstance().addPropertyChangeListener(myPropertyChangeListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                TodoConfiguration.getInstance().removePropertyChangeListener(myPropertyChangeListener);
            }
        });
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(AppTopics.FILE_TYPES, (Object)new MyFileTypeListener());
    }

    public void loadState(Element element) {
        this.mySelectedIndex = 0;
        try {
            this.mySelectedIndex = Integer.parseInt(element.getAttributeValue(ATTRIBUTE_SELECTED_INDEX));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        for (Element child : element.getChildren()) {
            if (!ELEMENT_TODO_PANEL.equals(child.getName())) continue;
            String id = child.getAttributeValue(ATTRIBUTE_ID);
            if (VALUE_SELECTED_FILE.equals(id)) {
                this.myCurrentPanelSettings.readExternal(child);
                continue;
            }
            if (VALUE_ALL.equals(id)) {
                this.myAllPanelSettings.readExternal(child);
                continue;
            }
            if (VALUE_DEFAULT_CHANGELIST.equals(id)) {
                this.myChangeListTodosPanelSettings.readExternal(child);
                continue;
            }
            throw new IllegalArgumentException("unknown id: " + id);
        }
    }

    public Element getState() {
        Element element = new Element("TodoView");
        if (this.myContentManager != null) {
            Content content = this.myContentManager.getSelectedContent();
            element.setAttribute(ATTRIBUTE_SELECTED_INDEX, Integer.toString(this.myContentManager.getIndexOfContent(content)));
        }
        Element selectedFileElement = new Element(ELEMENT_TODO_PANEL);
        selectedFileElement.setAttribute(ATTRIBUTE_ID, VALUE_SELECTED_FILE);
        this.myCurrentPanelSettings.writeExternal(selectedFileElement);
        element.addContent(selectedFileElement);
        Element allElement = new Element(ELEMENT_TODO_PANEL);
        allElement.setAttribute(ATTRIBUTE_ID, VALUE_ALL);
        this.myAllPanelSettings.writeExternal(allElement);
        element.addContent(allElement);
        Element changeListElement = new Element(ELEMENT_TODO_PANEL);
        changeListElement.setAttribute(ATTRIBUTE_ID, VALUE_DEFAULT_CHANGELIST);
        this.myChangeListTodosPanelSettings.writeExternal(changeListElement);
        element.addContent(changeListElement);
        return element;
    }

    public void dispose() {
        this.myVCSManager.removeVcsListener((VcsListener)this.myVcsListener);
    }

    public void initToolWindow(ToolWindow toolWindow) {
        Content content;
        Content allTodosContent = ContentFactory.SERVICE.getInstance().createContent(null, IdeBundle.message((String)"title.project", (Object[])new Object[0]), false);
        this.myAllTodos = new TodoPanel(this.myProject, this.myAllPanelSettings, false, allTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, Project project) {
                AllTodosTreeBuilder builder = new AllTodosTreeBuilder(tree, treeModel, project);
                builder.init();
                return builder;
            }
        };
        allTodosContent.setComponent((JComponent)((Object)this.myAllTodos));
        Disposer.register((Disposable)this, (Disposable)this.myAllTodos);
        Content currentFileTodosContent = ContentFactory.SERVICE.getInstance().createContent(null, IdeBundle.message((String)"title.todo.current.file", (Object[])new Object[0]), false);
        this.myCurrentFileTodos = new CurrentFileTodosPanel(this.myProject, this.myCurrentPanelSettings, currentFileTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, Project project) {
                CurrentFileTodosTreeBuilder builder = new CurrentFileTodosTreeBuilder(tree, treeModel, project);
                builder.init();
                return builder;
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myCurrentFileTodos);
        currentFileTodosContent.setComponent((JComponent)((Object)this.myCurrentFileTodos));
        this.myChangeListTodosContent = ContentFactory.SERVICE.getInstance().createContent(null, IdeBundle.message((String)"changelist.todo.title", (Object[])new Object[]{ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getName()}), false);
        this.myChangeListTodos = new ChangeListTodosPanel(this.myProject, this.myCurrentPanelSettings, this.myChangeListTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(JTree tree, DefaultTreeModel treeModel, Project project) {
                ChangeListTodosTreeBuilder builder = new ChangeListTodosTreeBuilder(tree, treeModel, project);
                builder.init();
                return builder;
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myChangeListTodos);
        this.myChangeListTodosContent.setComponent((JComponent)((Object)this.myChangeListTodos));
        this.myContentManager = toolWindow.getContentManager();
        this.myContentManager.addContent(allTodosContent);
        this.myContentManager.addContent(currentFileTodosContent);
        if (this.myVCSManager.getAllActiveVcss().length > 0) {
            this.myVcsListener.myIsVisible = true;
            this.myContentManager.addContent(this.myChangeListTodosContent);
        }
        content = (content = this.myContentManager.getContent(this.mySelectedIndex)) == null ? allTodosContent : content;
        this.myContentManager.setSelectedContent(content);
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void beforeFileTypesChanged(FileTypeEvent event) {
        }

        public void fileTypesChanged(FileTypeEvent e) {
            DumbService.getInstance((Project)TodoView.this.myProject).smartInvokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TodoView.this.myProject.isDisposed()) {
                        return;
                    }
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                        @Override
                        public void run() {
                            if (TodoView.this.myAllTodos == null) {
                                return;
                            }
                            ApplicationManager.getApplication().runReadAction(new Runnable(){

                                @Override
                                public void run() {
                                    TodoView.this.myAllTodos.rebuildCache();
                                    TodoView.this.myCurrentFileTodos.rebuildCache();
                                    TodoView.this.myChangeListTodos.rebuildCache();
                                }
                            });
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    TodoView.this.myAllTodos.updateTree();
                                    TodoView.this.myCurrentFileTodos.updateTree();
                                    TodoView.this.myChangeListTodos.updateTree();
                                }
                            }, ModalityState.NON_MODAL);
                        }
                    }, IdeBundle.message((String)"progress.looking.for.todos", (Object[])new Object[0]), false, TodoView.this.myProject);
                }
            });
        }
    }

    private final class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("todoPatterns".equals(e.getPropertyName()) || "todoFilters".equals(e.getPropertyName())) {
                this._updateFilters();
            }
        }

        private void _updateFilters() {
            try {
                this.updateFilters();
            }
            catch (ProcessCanceledException e) {
                DumbService.getInstance((Project)TodoView.this.myProject).smartInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyPropertyChangeListener.this._updateFilters();
                    }
                }, ModalityState.NON_MODAL);
            }
        }

        private void updateFilters() {
            TodoView.this.myCurrentFileTodos.updateTodoFilter();
            TodoView.this.myAllTodos.updateTodoFilter();
            TodoView.this.myChangeListTodos.updateTodoFilter();
        }
    }

    private final class MyVcsListener
    implements VcsListener {
        private boolean myIsVisible;

        private MyVcsListener() {
        }

        public void directoryMappingChanged() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TodoView.this.myContentManager == null) {
                        return;
                    }
                    if (TodoView.this.myProject.isDisposed()) {
                        return;
                    }
                    AbstractVcs[] vcss = TodoView.this.myVCSManager.getAllActiveVcss();
                    if (MyVcsListener.this.myIsVisible && vcss.length == 0) {
                        TodoView.this.myContentManager.removeContent(TodoView.this.myChangeListTodosContent, false);
                        MyVcsListener.this.myIsVisible = false;
                    } else if (!MyVcsListener.this.myIsVisible && vcss.length > 0) {
                        TodoView.this.myContentManager.addContent(TodoView.this.myChangeListTodosContent);
                        MyVcsListener.this.myIsVisible = true;
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }
}

