/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NotificationConfiguration", storages={@Storage(id="other", file="$APP_CONFIG$/notifications.xml")})
public class NotificationsConfiguration
implements ApplicationComponent,
Notifications,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.impl.NotificationsConfiguration");
    private Map<String, NotificationSettings> myIdToSettingsMap;
    private MessageBus myMessageBus;

    public NotificationsConfiguration(@NotNull MessageBus bus) {
        if (bus == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsConfiguration.<init> must not be null");
        }
        this.myIdToSettingsMap = new LinkedHashMap();
        this.myMessageBus = bus;
    }

    public static NotificationsConfiguration getNotificationsConfiguration() {
        return (NotificationsConfiguration)ApplicationManager.getApplication().getComponent(NotificationsConfiguration.class);
    }

    public static NotificationSettings[] getAllSettings() {
        return NotificationsConfiguration.getNotificationsConfiguration()._getAllSettings();
    }

    public static void remove(NotificationSettings[] toRemove) {
        NotificationsConfiguration.getNotificationsConfiguration()._remove(toRemove);
    }

    public static void removeAll() {
        NotificationsConfiguration.getNotificationsConfiguration()._removeAll();
    }

    private void _removeAll() {
        this.myIdToSettingsMap.clear();
    }

    private void _remove(NotificationSettings[] toRemove) {
        for (NotificationSettings settings : toRemove) {
            this.myIdToSettingsMap.remove(settings.getGroupId());
        }
    }

    private NotificationSettings[] _getAllSettings() {
        ArrayList<NotificationSettings> result = new ArrayList<NotificationSettings>(this.myIdToSettingsMap.values());
        Collections.sort(result, new Comparator<NotificationSettings>(){

            @Override
            public int compare(NotificationSettings o1, NotificationSettings o2) {
                return o1.getGroupId().compareToIgnoreCase(o2.getGroupId());
            }
        });
        return result.toArray(new NotificationSettings[result.size()]);
    }

    @Nullable
    public static NotificationSettings getSettings(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsConfiguration.getSettings must not be null");
        }
        NotificationsConfiguration configuration = NotificationsConfiguration.getNotificationsConfiguration();
        return configuration.myIdToSettingsMap.get(groupId);
    }

    @NotNull
    public String getComponentName() {
        if ("NotificationsConfiguration" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/notification/impl/NotificationsConfiguration.getComponentName must not return null");
        }
        return "NotificationsConfiguration";
    }

    public void initComponent() {
        this.myMessageBus.connect().subscribe(TOPIC, (Object)this);
    }

    public void disposeComponent() {
        this.myIdToSettingsMap.clear();
    }

    public void register(@NotNull String id, @NotNull NotificationDisplayType displayType) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsConfiguration.register must not be null");
        }
        if (displayType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/notification/impl/NotificationsConfiguration.register must not be null");
        }
        if (!this.myIdToSettingsMap.containsKey(id)) {
            this.myIdToSettingsMap.put(id, new NotificationSettings(id, displayType));
        }
    }

    public boolean isRegistered(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsConfiguration.isRegistered must not be null");
        }
        return this.myIdToSettingsMap.containsKey(id);
    }

    public void notify(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsConfiguration.notify must not be null");
        }
    }

    public void notify(@NotNull Notification notification, @NotNull NotificationDisplayType defaultDisplayType) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/NotificationsConfiguration.notify must not be null");
        }
        if (defaultDisplayType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/notification/impl/NotificationsConfiguration.notify must not be null");
        }
    }

    public Element getState() {
        Element element = new Element("NotificationsConfiguration");
        for (NotificationSettings settings : this.myIdToSettingsMap.values()) {
            element.addContent(settings.save());
        }
        return element;
    }

    public void loadState(Element state) {
        for (Element child : state.getChildren("notification")) {
            NotificationSettings settings = NotificationSettings.load(child);
            if (settings == null) continue;
            String id = settings.getGroupId();
            LOG.assertTrue(!this.myIdToSettingsMap.containsKey(id), (Object)String.format("Settings for '%s' already loaded!", id));
            this.myIdToSettingsMap.put(id, settings);
        }
    }
}

