/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.plaf.beg.BegMenuItemUI;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class ActionMenuItem
extends JMenuItem {
    private static final Icon ourCheckedIcon = IconLoader.getIcon((String)"/actions/check.png");
    private static final Icon ourUncheckedIcon = new EmptyIcon(18, 18);
    private final AnAction myAction;
    private final Presentation myPresentation;
    private final String myPlace;
    private DataContext myContext;
    private AnActionEvent myEvent;
    private MenuItemSynchronizer myMenuItemSynchronizer;
    private boolean myEnableMnemonics;

    public ActionMenuItem(AnAction action, Presentation presentation, String place, DataContext context, boolean enableMnemonics, boolean prepareNow) {
        this.myAction = action;
        this.myPresentation = presentation;
        this.myPlace = place;
        this.myContext = context;
        this.myEnableMnemonics = enableMnemonics;
        this.myEvent = new AnActionEvent(null, context, place, this.myPresentation, ActionManager.getInstance(), 0);
        this.addActionListener(new ActionTransmitter());
        this.setBorderPainted(false);
        if (prepareNow) {
            this.init();
        } else {
            this.setText("loading...");
        }
    }

    public void prepare() {
        this.init();
        this.installSynchronizer();
    }

    @Override
    public void fireActionPerformed(ActionEvent event) {
        super.fireActionPerformed(event);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.installSynchronizer();
        this.init();
    }

    @Override
    public void removeNotify() {
        this.uninstallSynchronizer();
        super.removeNotify();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    private void installSynchronizer() {
        if (this.myMenuItemSynchronizer == null) {
            this.myMenuItemSynchronizer = new MenuItemSynchronizer();
        }
    }

    private void uninstallSynchronizer() {
        if (this.myMenuItemSynchronizer != null) {
            Disposer.dispose((Disposable)this.myMenuItemSynchronizer);
            this.myMenuItemSynchronizer = null;
        }
    }

    private void init() {
        int mnemonicIndex;
        this.setVisible(this.myPresentation.isVisible());
        this.setEnabled(this.myPresentation.isEnabled());
        this.setMnemonic(this.myEnableMnemonics ? this.myPresentation.getMnemonic() : 0);
        this.setText(this.myPresentation.getText());
        int n = mnemonicIndex = this.myEnableMnemonics ? this.myPresentation.getDisplayedMnemonicIndex() : -1;
        if (this.getText() != null && mnemonicIndex >= 0 && mnemonicIndex < this.getText().length()) {
            this.setDisplayedMnemonicIndex(mnemonicIndex);
        }
        this.updateIcon();
        String id = ActionManager.getInstance().getId(this.myAction);
        if (id != null) {
            Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(id);
            this.setAcceleratorFromShortcuts(shortcuts);
        } else {
            ShortcutSet shortcutSet = this.myAction.getShortcutSet();
            if (shortcutSet != null) {
                this.setAcceleratorFromShortcuts(shortcutSet.getShortcuts());
            }
        }
    }

    private void setAcceleratorFromShortcuts(Shortcut[] shortcuts) {
        for (Shortcut shortcut : shortcuts) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            this.setAccelerator(((KeyboardShortcut)shortcut).getFirstKeyStroke());
            break;
        }
    }

    @Override
    public void updateUI() {
        if (UIUtil.isStandardMenuLAF()) {
            super.updateUI();
        } else {
            this.setUI(BegMenuItemUI.createUI(this));
        }
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        super.menuSelectionChanged(isIncluded);
        ActionMenu.showDescriptionInStatusBar(isIncluded, this, this.myPresentation.getDescription());
    }

    public String getFirstShortcutText() {
        return KeymapUtil.getFirstKeyboardShortcutText((AnAction)this.myAction);
    }

    public void updateContext(DataContext context) {
        this.myContext = context;
        this.myEvent = new AnActionEvent(null, context, this.myPlace, this.myPresentation, ActionManager.getInstance(), 0);
    }

    private void updateIcon() {
        if (this.myAction instanceof Toggleable && this.myPresentation.getIcon() == null) {
            this.myAction.update(this.myEvent);
            if (Boolean.TRUE.equals(this.myEvent.getPresentation().getClientProperty("selected"))) {
                this.setIcon(ourCheckedIcon);
                this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)ourCheckedIcon));
            } else {
                this.setIcon(ourUncheckedIcon);
                this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)ourUncheckedIcon));
            }
        } else if (!SystemInfo.isMac || UISettings.getInstance().SHOW_ICONS_IN_MENUS) {
            Icon icon = this.myPresentation.getIcon();
            this.setIcon(icon);
            if (this.myPresentation.getDisabledIcon() != null) {
                this.setDisabledIcon(this.myPresentation.getDisabledIcon());
            } else {
                this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
            }
        }
    }

    private final class MenuItemSynchronizer
    implements PropertyChangeListener,
    Disposable {
        @NonNls
        private static final String SELECTED = "selected";
        private final Set<String> mySynchronized = new HashSet<String>();

        private MenuItemSynchronizer() {
            ActionMenuItem.this.myPresentation.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void dispose() {
            ActionMenuItem.this.myPresentation.removePropertyChangeListener((PropertyChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean queueForDispose = ActionMenuItem.this.getParent() == null;
            String name = e.getPropertyName();
            if (this.mySynchronized.contains(name)) {
                return;
            }
            this.mySynchronized.add(name);
            try {
                if ("visible".equals(name)) {
                    boolean visible = ActionMenuItem.this.myPresentation.isVisible();
                    if (!visible && SystemInfo.isMacSystemMenu && ActionMenuItem.this.myPlace == "MainMenu") {
                        ActionMenuItem.this.setEnabled(false);
                    } else {
                        ActionMenuItem.this.setVisible(visible);
                    }
                } else if ("enabled".equals(name)) {
                    ActionMenuItem.this.setEnabled(ActionMenuItem.this.myPresentation.isEnabled());
                    ActionMenuItem.this.updateIcon();
                } else if ("mnemonicKey".equals(name)) {
                    ActionMenuItem.this.setMnemonic(ActionMenuItem.this.myPresentation.getMnemonic());
                } else if ("mnemonicIndex".equals(name)) {
                    ActionMenuItem.this.setDisplayedMnemonicIndex(ActionMenuItem.this.myPresentation.getDisplayedMnemonicIndex());
                } else if ("text".equals(name)) {
                    ActionMenuItem.this.setText(ActionMenuItem.this.myPresentation.getText());
                } else if ("icon".equals(name) || "disabledIcon".equals(name)) {
                    ActionMenuItem.this.updateIcon();
                } else if (SELECTED.equals(name)) {
                    ActionMenuItem.this.updateIcon();
                }
                this.mySynchronized.remove(name);
            }
            catch (Throwable throwable) {
                this.mySynchronized.remove(name);
                if (queueForDispose) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (ActionMenuItem.this.getParent() == null) {
                                ActionMenuItem.this.uninstallSynchronizer();
                            }
                        }
                    });
                }
                throw throwable;
            }
            if (queueForDispose) {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    private final class ActionTransmitter
    implements ActionListener {
        private ActionTransmitter() {
        }

        private boolean isInTree(Component component) {
            if (component instanceof Window) {
                return component.isShowing();
            }
            Window windowAncestor = SwingUtilities.getWindowAncestor(component);
            return windowAncestor != null && windowAncestor.isShowing();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnActionEvent event = new AnActionEvent((InputEvent)new MouseEvent(ActionMenuItem.this, 501, 0L, e.getModifiers(), ActionMenuItem.this.getWidth() / 2, ActionMenuItem.this.getHeight() / 2, 1, false), ActionMenuItem.this.myContext, ActionMenuItem.this.myPlace, ActionMenuItem.this.myPresentation, ActionManager.getInstance(), e.getModifiers());
            if (ActionUtil.lastUpdateAndCheckDumb((AnAction)ActionMenuItem.this.myAction, (AnActionEvent)event, (boolean)false)) {
                ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
                actionManager.fireBeforeActionPerformed(ActionMenuItem.this.myAction, ActionMenuItem.this.myContext, event);
                Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(event.getDataContext());
                if (component != null && !this.isInTree(component)) {
                    return;
                }
                ActionMenuItem.this.myAction.actionPerformed(event);
                actionManager.queueActionPerformedEvent(ActionMenuItem.this.myAction, ActionMenuItem.this.myContext, event);
            }
        }
    }
}

