/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.StringProperty;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

abstract class BaseExternalTool
implements DiffTool {
    private final BooleanProperty myEnableProperty;
    private final StringProperty myToolProperty;

    protected BaseExternalTool(BooleanProperty enableProperty, StringProperty toolProperty) {
        this.myEnableProperty = enableProperty;
        this.myToolProperty = toolProperty;
    }

    public boolean canShow(DiffRequest request) {
        AbstractProperty.AbstractPropertyContainer config = DiffManagerImpl.getInstanceEx().getProperties();
        if (!this.myEnableProperty.value(config)) {
            return false;
        }
        String path = this.getToolPath();
        if (path == null || path.length() == 0) {
            return false;
        }
        DiffContent[] contents = request.getContents();
        if (contents.length != 2) {
            return false;
        }
        if (this.externalize(request, 0) == null) {
            return false;
        }
        return this.externalize(request, 1) != null;
    }

    protected abstract ContentExternalizer externalize(DiffRequest var1, int var2);

    private String getToolPath() {
        return (String)this.myToolProperty.get(DiffManagerImpl.getInstanceEx().getProperties());
    }

    public void show(DiffRequest request) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(this.getToolPath());
        try {
            commandLine.addParameter(this.convertToPath(request, 0));
            commandLine.addParameter(this.convertToPath(request, 1));
            Runtime.getRuntime().exec(commandLine.getCommands());
        }
        catch (IOException e) {
            ExecutionErrorDialog.show((ExecutionException)new ExecutionException(e.getMessage()), (String)DiffBundle.message((String)"cant.launch.diff.tool.error.message", (Object[])new Object[0]), (Project)request.getProject());
        }
    }

    private String convertToPath(DiffRequest request, int index) throws IOException {
        return this.externalize(request, index).getContentFile().getAbsolutePath();
    }

    @Nullable
    protected static VirtualFile getLocalFile(VirtualFile file) {
        if (file != null && file.isInLocalFileSystem()) {
            return file;
        }
        return null;
    }

    protected static class LocalFileExternalizer
    implements ContentExternalizer {
        private final File myFile;

        public LocalFileExternalizer(File file) {
            this.myFile = file;
        }

        @Override
        public File getContentFile() {
            return this.myFile;
        }

        @Nullable
        public static LocalFileExternalizer tryCreate(VirtualFile file) {
            if (file == null || !file.isValid()) {
                return null;
            }
            if (!file.isInLocalFileSystem()) {
                return null;
            }
            return new LocalFileExternalizer(new File(file.getPath().replace('/', File.separatorChar)));
        }
    }

    protected static interface ContentExternalizer {
        public File getContentFile() throws IOException;
    }
}

