/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.Change;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.ConflictChange;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeList;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.util.TextRange;

class MergeConflict
extends ChangeType.ChangeSide
implements DiffRangeMarker.RangeInvalidListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.MergeConflict");
    private final Change.HighlighterHolder myCommonHighlighterHolder = new Change.HighlighterHolder();
    private final MergeList myMergeList;
    private final DiffRangeMarker myCommonRange;
    private ConflictChange[] myChanges;

    private MergeConflict(TextRange commonRange, MergeList mergeList) {
        this.myCommonRange = new DiffRangeMarker((DocumentEx)mergeList.getBaseDocument(), commonRange, this);
        this.myMergeList = mergeList;
    }

    @Override
    public Change.HighlighterHolder getHighlighterHolder() {
        return this.myCommonHighlighterHolder;
    }

    @Override
    public DiffRangeMarker getRange() {
        return this.myCommonRange;
    }

    public static Change[] createChanges(TextRange leftMarker, TextRange baseMarker, TextRange rightMarker, MergeList mergeList) {
        MergeConflict conflict = new MergeConflict(baseMarker, mergeList);
        return conflict.createChanges(leftMarker, rightMarker);
    }

    private Change[] createChanges(TextRange leftMarker, TextRange rightMarker) {
        LOG.assertTrue(this.myChanges == null);
        this.myChanges = new ConflictChange[]{new ConflictChange(this, FragmentSide.SIDE1, leftMarker), new ConflictChange(this, FragmentSide.SIDE2, rightMarker)};
        return this.myChanges;
    }

    public void conflictRemoved() {
        for (ConflictChange change : this.myChanges) {
            change.getOriginalSide().getHighlighterHolder().removeHighlighters();
        }
        this.myCommonHighlighterHolder.removeHighlighters();
        this.myMergeList.removeChanges(this.myChanges);
        this.myCommonRange.removeListener(this);
    }

    public Document getOriginalDocument(FragmentSide mergeSide) {
        return this.myMergeList.getChanges(mergeSide).getDocument(MergeList.BRANCH_SIDE);
    }

    @Override
    public void onRangeInvalidated() {
        this.conflictRemoved();
    }

    public void onChangeRemoved(FragmentSide mergeSide, ConflictChange conflictChange) {
        LOG.assertTrue(this.myChanges[mergeSide.getIndex()] == conflictChange);
        this.myChanges[mergeSide.getIndex()] = null;
    }

    public MergeList getMergeList() {
        return this.myMergeList;
    }
}

