/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.impl.FontInfo;
import gnu.trove.TIntHashSet;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NonNls;

public class ComplementaryFontsRegistry {
    private static final Object lock;
    private static final ArrayList<String> ourFontNames;
    private static final LinkedHashMap<FontKey, FontInfo> ourUsedFonts;
    private static FontKey ourSharedKeyInstance;
    private static FontInfo ourSharedDefaultFont;
    private static final TIntHashSet ourUndisplayableChars;
    @NonNls
    private static final String BOLD_SUFFIX = ".bold";
    @NonNls
    private static final String ITALIC_SUFFIX = ".italic";

    private ComplementaryFontsRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontInfo getFontAbleToDisplay(char c, int size, int style, String defaultFontFamily) {
        Object object = lock;
        synchronized (object) {
            if (ComplementaryFontsRegistry.ourSharedKeyInstance.mySize == size && ComplementaryFontsRegistry.ourSharedKeyInstance.myStyle == style && ComplementaryFontsRegistry.ourSharedKeyInstance.myFamilyName != null && ComplementaryFontsRegistry.ourSharedKeyInstance.myFamilyName.equals(defaultFontFamily) && ourSharedDefaultFont != null && (c < '\u0080' || ourSharedDefaultFont.canDisplay(c))) {
                return ourSharedDefaultFont;
            }
            ComplementaryFontsRegistry.ourSharedKeyInstance.myFamilyName = defaultFontFamily;
            ComplementaryFontsRegistry.ourSharedKeyInstance.mySize = size;
            ComplementaryFontsRegistry.ourSharedKeyInstance.myStyle = style;
            FontInfo defaultFont = ourUsedFonts.get(ourSharedKeyInstance);
            if (defaultFont == null) {
                defaultFont = new FontInfo(defaultFontFamily, size, style);
                ourUsedFonts.put(ourSharedKeyInstance, defaultFont);
                ourSharedKeyInstance = new FontKey(null, 0, 0);
            }
            ourSharedDefaultFont = defaultFont;
            if (c < '\u0080' || defaultFont.canDisplay(c)) {
                return defaultFont;
            }
            if (ourUndisplayableChars.contains((int)c)) {
                return defaultFont;
            }
            Collection<FontInfo> descriptors = ourUsedFonts.values();
            for (FontInfo font : descriptors) {
                if (font.getSize() != size || font.getStyle() != style || !font.canDisplay(c)) continue;
                return font;
            }
            for (int i = 0; i < ourFontNames.size(); ++i) {
                String name = ourFontNames.get(i);
                FontInfo font = new FontInfo(name, size, style);
                if (!font.canDisplay(c)) continue;
                ourUsedFonts.put(new FontKey(name, size, style), font);
                ourFontNames.remove(i);
                return font;
            }
            ourUndisplayableChars.add((int)c);
            return defaultFont;
        }
    }

    static {
        String[] fontNames;
        lock = new String("common lock");
        ourSharedKeyInstance = new FontKey(null, 0, 0);
        ourUndisplayableChars = new TIntHashSet();
        ourFontNames = new ArrayList();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String fontName : fontNames = graphicsEnvironment.getAvailableFontFamilyNames()) {
            if (fontName.endsWith(BOLD_SUFFIX) || fontName.endsWith(ITALIC_SUFFIX)) continue;
            ourFontNames.add(fontName);
        }
        ourUsedFonts = new LinkedHashMap();
    }

    private static class FontKey {
        public String myFamilyName;
        public int mySize;
        public int myStyle;

        public FontKey(String familyName, int size, int style) {
            this.myFamilyName = familyName;
            this.mySize = size;
            this.myStyle = style;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            FontKey fontKey = (FontKey)o;
            if (this.mySize != fontKey.mySize) {
                return false;
            }
            if (this.myStyle != fontKey.myStyle) {
                return false;
            }
            return this.myFamilyName.equals(fontKey.myFamilyName);
        }

        public int hashCode() {
            int result = this.myFamilyName.hashCode();
            result = 29 * result + this.mySize;
            result = 29 * result + this.myStyle;
            return result;
        }
    }
}

